# Copyright (c) 2024, NVIDIA CORPORATION.

from collections.abc import Sequence
from typing import Any

from pylibcudf.gpumemoryview import gpumemoryview
from pylibcudf.scalar import Scalar
from pylibcudf.types import DataType

class Column:
    def __init__(
        self,
        data_type: DataType,
        size: int,
        data: gpumemoryview | None,
        mask: gpumemoryview | None,
        null_count: int,
        offset: int,
        children: list[Column],
    ) -> None: ...
    def type(self) -> DataType: ...
    def child(self, index: int) -> Column: ...
    def size(self) -> int: ...
    def null_count(self) -> int: ...
    def offset(self) -> int: ...
    def data(self) -> gpumemoryview | None: ...
    def null_mask(self) -> gpumemoryview | None: ...
    def children(self) -> list[Column]: ...
    def copy(self) -> Column: ...
    def with_mask(
        self, mask: gpumemoryview | None, null_count: int
    ) -> Column: ...
    def list_view(self) -> ListColumnView: ...
    @staticmethod
    def from_scalar(scalar: Scalar, size: int) -> Column: ...
    @staticmethod
    def all_null_like(like: Column, size: int) -> Column: ...
    @staticmethod
    def from_cuda_array_interface_obj(obj: Any) -> Column: ...

class ListColumnView:
    def __init__(self, column: Column): ...
    def child(self) -> Column: ...
    def offsets(self) -> Column: ...

def is_c_contiguous(
    shape: Sequence[int], strides: Sequence[int], itemsize: int
) -> bool: ...
