# Copyright (c) 2024, NVIDIA CORPORATION.

from enum import IntEnum

from rmm.pylibrmm.stream import Stream

from pylibcudf.column import Column
from pylibcudf.scalar import Scalar

class DatetimeComponent(IntEnum):
    YEAR = ...
    MONTH = ...
    DAY = ...
    WEEKDAY = ...
    HOUR = ...
    MINUTE = ...
    SECOND = ...
    MILLISECOND = ...
    MICROSECOND = ...
    NANOSECOND = ...

class RoundingFrequency(IntEnum):
    DAY = ...
    HOUR = ...
    MINUTE = ...
    SECOND = ...
    MILLISECOND = ...
    MICROSECOND = ...
    NANOSECOND = ...

def extract_datetime_component(
    input: Column, component: DatetimeComponent, stream: Stream | None = None
) -> Column: ...
def ceil_datetimes(
    input: Column, freq: RoundingFrequency, stream: Stream | None = None
) -> Column: ...
def floor_datetimes(
    input: Column, freq: RoundingFrequency, stream: Stream | None = None
) -> Column: ...
def round_datetimes(
    input: Column, freq: RoundingFrequency, stream: Stream | None = None
) -> Column: ...
def add_calendrical_months(
    input: Column, months: Column | Scalar, stream: Stream | None = None
) -> Column: ...
def day_of_year(input: Column, stream: Stream | None = None) -> Column: ...
def is_leap_year(input: Column, stream: Stream | None = None) -> Column: ...
def last_day_of_month(
    input: Column, stream: Stream | None = None
) -> Column: ...
def extract_quarter(input: Column, stream: Stream | None = None) -> Column: ...
def days_in_month(input: Column, stream: Stream | None = None) -> Column: ...
