# Copyright (c) 2024-2025, NVIDIA CORPORATION.

from enum import IntEnum

from rmm.pylibrmm.stream import Stream

from pylibcudf.column import Column
from pylibcudf.types import DataType

class UnaryOperator(IntEnum):
    SIN = ...
    COS = ...
    TAN = ...
    ARCSIN = ...
    ARCCOS = ...
    ARCTAN = ...
    SINH = ...
    COSH = ...
    TANH = ...
    ARCSINH = ...
    ARCCOSH = ...
    ARCTANH = ...
    EXP = ...
    LOG = ...
    SQRT = ...
    CBRT = ...
    CEIL = ...
    FLOOR = ...
    ABS = ...
    RINT = ...
    BIT_COUNT = ...
    BIT_INVERT = ...
    NOT = ...
    NEGATE = ...

def unary_operation(
    input: Column, op: UnaryOperator, stream: Stream | None = None
) -> Column: ...
def is_null(input: Column, stream: Stream | None = None) -> Column: ...
def is_valid(input: Column, stream: Stream | None = None) -> Column: ...
def cast(
    input: Column, data_type: DataType, stream: Stream | None = None
) -> Column: ...
def is_nan(input: Column, stream: Stream | None = None) -> Column: ...
def is_not_nan(input: Column, stream: Stream | None = None) -> Column: ...
def is_supported_cast(from_: DataType, to: DataType) -> bool: ...
