# SPDX-FileCopyrightText: Copyright (c) 2024, NVIDIA CORPORATION.
# SPDX-License-Identifier: Apache-2.0

from typing_extensions import Self

from rmm.pylibrmm.memory_resource import DeviceMemoryResource
from rmm.pylibrmm.stream import Stream

from pylibcudf.io.types import (
    CompressionType,
    QuoteStyle,
    SinkInfo,
    SourceInfo,
    TableWithMetadata,
)
from pylibcudf.table import Table
from pylibcudf.types import DataType

class CsvReaderOptions:
    def __init__(self): ...
    def set_header(self, header: int): ...
    def set_names(self, col_names: list[str]): ...
    def set_prefix(self, prefix: str): ...
    def set_use_cols_indexes(self, col_indices: list[int]): ...
    def set_use_cols_names(self, col_names: list[str]): ...
    def set_delimiter(self, delimiter: str): ...
    def set_thousands(self, thousands: str): ...
    def set_comment(self, comment: str): ...
    def set_parse_dates(self, val: list[int | str]): ...
    def set_parse_hex(self, val: list[int | str]): ...
    def set_dtypes(self, types: dict[str, DataType] | list[DataType]): ...
    def set_true_values(self, true_values: list[str]): ...
    def set_false_values(self, false_values: list[str]): ...
    def set_na_values(self, na_values: list[str]): ...
    def set_source(self, src: SourceInfo) -> None: ...
    @staticmethod
    def builder(source: SourceInfo) -> CsvReaderOptionsBuilder: ...

class CsvReaderOptionsBuilder:
    def __init__(self): ...
    def compression(self, compression: CompressionType) -> Self: ...
    def mangle_dupe_cols(self, mangle_dupe_cols: bool) -> Self: ...
    def byte_range_offset(self, byte_range_offset: int) -> Self: ...
    def byte_range_size(self, byte_range_size: int) -> Self: ...
    def nrows(self, nrows: int) -> Self: ...
    def skiprows(self, skiprows: int) -> Self: ...
    def skipfooter(self, skipfooter: int) -> Self: ...
    def quoting(self, quoting: QuoteStyle) -> Self: ...
    def lineterminator(self, lineterminator: str) -> Self: ...
    def quotechar(self, quotechar: str) -> Self: ...
    def decimal(self, decimal: str) -> Self: ...
    def delim_whitespace(self, delim_whitespace: bool) -> Self: ...
    def skipinitialspace(self, skipinitialspace: bool) -> Self: ...
    def skip_blank_lines(self, skip_blank_lines: bool) -> Self: ...
    def doublequote(self, doublequote: bool) -> Self: ...
    def keep_default_na(self, keep_default_na: bool) -> Self: ...
    def na_filter(self, na_filter: bool) -> Self: ...
    def dayfirst(self, dayfirst: bool) -> Self: ...
    def delimiter(self, delimiter: str) -> Self: ...
    def build(self) -> CsvReaderOptions: ...

def read_csv(
    options: CsvReaderOptions,
    stream: Stream = None,
    mr: DeviceMemoryResource = None,
) -> TableWithMetadata: ...
def write_csv(options: CsvWriterOptions, stream: Stream = None): ...

class CsvWriterOptions:
    def __init__(self): ...
    @staticmethod
    def builder(sink: SinkInfo, table: Table) -> CsvWriterOptionsBuilder: ...

class CsvWriterOptionsBuilder:
    def __init__(self): ...
    def names(self, names: list) -> Self: ...
    def na_rep(self, val: str) -> Self: ...
    def include_header(self, val: bool) -> Self: ...
    def rows_per_chunk(self, val: int) -> Self: ...
    def line_terminator(self, term: str) -> Self: ...
    def inter_column_delimiter(self, delim: str) -> Self: ...
    def true_value(self, val: str) -> Self: ...
    def false_value(self, val: str) -> Self: ...
    def build(self) -> CsvWriterOptions: ...

def is_supported_write_csv(type: DataType) -> bool: ...
