# SPDX-FileCopyrightText: Copyright (c) 2025, NVIDIA CORPORATION & AFFILIATES.
# SPDX-License-Identifier: Apache-2.0
from __future__ import annotations

from collections.abc import Callable, Mapping
from typing import TypeVar

T = TypeVar("T")

class Options:
    def __init__(
        self,
        options_as_strings: Mapping[str, str] | None = None,
    ) -> None: ...
    def get(
        self, key: str, *, return_type: type[T], factory: Callable[[str], T]
    ) -> T: ...
    def get_or_default(self, key: str, *, default_value: T) -> T: ...
    def get_strings(self) -> dict[str, str]: ...
    def serialize(self) -> bytes: ...
    @staticmethod
    def deserialize(serialized_buffer: bytes) -> Options: ...
    def __getstate__(self) -> bytes: ...
    def __setstate__(self, state: bytes) -> None: ...

def get_environment_variables(key_regex: str = ...) -> dict[str, str]: ...
