# SPDX-FileCopyrightText: Copyright (c) 2025, NVIDIA CORPORATION & AFFILIATES.
# SPDX-License-Identifier: Apache-2.0

from enum import IntEnum

class AllocType(IntEnum):
    PRIMARY = ...
    FALLBACK = ...
    ALL = ...

class ScopedMemoryRecord:
    def num_total_allocs(self, alloc_type: AllocType = AllocType.ALL) -> int: ...
    def num_current_allocs(self, alloc_type: AllocType = AllocType.ALL) -> int: ...
    def current(self, alloc_type: AllocType = AllocType.ALL) -> int: ...
    def total(self, alloc_type: AllocType = AllocType.ALL) -> int: ...
    def peak(self, alloc_type: AllocType = AllocType.ALL) -> int: ...
    def record_allocation(self, alloc_type: AllocType, nbytes: int) -> None: ...
    def record_deallocation(self, alloc_type: AllocType, nbytes: int) -> None: ...
