# SPDX-FileCopyrightText: Copyright (c) 2019-2025, NVIDIA CORPORATION.
# SPDX-License-Identifier: Apache-2.0
from rmm.librmm.memory_resource cimport device_memory_resource


cdef extern from "rmm/mr/per_device_resource.hpp" namespace "rmm" nogil:
    cdef cppclass cuda_device_id:
        ctypedef int value_type

        cuda_device_id(value_type id)

        value_type value()

cdef extern from "rmm/mr/per_device_resource.hpp" \
        namespace "rmm::mr" nogil:
    cdef device_memory_resource* set_current_device_resource(
        device_memory_resource* new_mr
    )
    cdef device_memory_resource* get_current_device_resource()
    cdef device_memory_resource* set_per_device_resource(
        cuda_device_id id, device_memory_resource* new_mr
    )
    cdef device_memory_resource* get_per_device_resource (
        cuda_device_id id
    )
