#=============================================================================
# Copyright (c) 2024, NVIDIA CORPORATION.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#=============================================================================

#[=======================================================================[.rst:
FindRDKAFKA
--------

Find RDKAFKA

Imported targets
^^^^^^^^^^^^^^^^

This module defines the following :prop_tgt:`IMPORTED` target(s):

``RDKAFKA::RDKAFKA``
  The RDKAFKA library, if found.

Result variables
^^^^^^^^^^^^^^^^

This module will set the following variables in your project:

``RDKAFKA_FOUND``
  True if RDKAFKA is found.
``RDKAFKA_INCLUDE_DIRS``
  The include directories needed to use RDKAFKA.
``RDKAFKA_LIBRARIES``
  The libraries needed to useRDKAFKA.
``RDKAFKA_VERSION_STRING``
  The version of the RDKAFKA library found. [OPTIONAL]

#]=======================================================================]

# Prefer using a Config module if it exists for this project



set(RDKAFKA_NO_CONFIG FALSE)
if(NOT RDKAFKA_NO_CONFIG)
  find_package(RDKAFKA CONFIG QUIET)
  if(RDKAFKA_FOUND)
    find_package_handle_standard_args(RDKAFKA DEFAULT_MSG RDKAFKA_CONFIG)
    return()
  endif()
endif()

find_path(RDKAFKA_INCLUDE_DIR NAMES rdkafkacpp.h PATH_SUFFIXES librdkafka)

set(RDKAFKA_IS_HEADER_ONLY FALSE)
if(NOT RDKAFKA_LIBRARY AND NOT RDKAFKA_IS_HEADER_ONLY)
  find_library(RDKAFKA_LIBRARY_RELEASE NAMES rdkafka++ NAMES_PER_DIR )
  find_library(RDKAFKA_LIBRARY_DEBUG   NAMES rdkafka++d   NAMES_PER_DIR )

  include(${CMAKE_ROOT}/Modules/SelectLibraryConfigurations.cmake)
  select_library_configurations(RDKAFKA)
  unset(RDKAFKA_FOUND) #incorrectly set by select_library_configurations
endif()

include(${CMAKE_ROOT}/Modules/FindPackageHandleStandardArgs.cmake)

if(RDKAFKA_IS_HEADER_ONLY)
  find_package_handle_standard_args(RDKAFKA
                                    FOUND_VAR RDKAFKA_FOUND
                                    REQUIRED_VARS RDKAFKA_INCLUDE_DIR
                                    VERSION_VAR )
else()
  find_package_handle_standard_args(RDKAFKA
                                    FOUND_VAR RDKAFKA_FOUND
                                    REQUIRED_VARS RDKAFKA_LIBRARY RDKAFKA_INCLUDE_DIR
                                    VERSION_VAR )
endif()

if(RDKAFKA_FOUND)
  set(RDKAFKA_INCLUDE_DIRS ${RDKAFKA_INCLUDE_DIR})

  if(NOT RDKAFKA_LIBRARIES)
    set(RDKAFKA_LIBRARIES ${RDKAFKA_LIBRARY})
  endif()

  if(NOT TARGET RDKAFKA::RDKAFKA)
    add_library(RDKAFKA::RDKAFKA UNKNOWN IMPORTED GLOBAL)
    set_target_properties(RDKAFKA::RDKAFKA PROPERTIES
      INTERFACE_INCLUDE_DIRECTORIES "${RDKAFKA_INCLUDE_DIRS}")

    if(RDKAFKA_LIBRARY_RELEASE)
      set_property(TARGET RDKAFKA::RDKAFKA APPEND PROPERTY
        IMPORTED_CONFIGURATIONS RELEASE)
      set_target_properties(RDKAFKA::RDKAFKA PROPERTIES
        IMPORTED_LOCATION_RELEASE "${RDKAFKA_LIBRARY_RELEASE}")
    endif()

    if(RDKAFKA_LIBRARY_DEBUG)
      set_property(TARGET RDKAFKA::RDKAFKA APPEND PROPERTY
        IMPORTED_CONFIGURATIONS DEBUG)
      set_target_properties(RDKAFKA::RDKAFKA PROPERTIES
        IMPORTED_LOCATION_DEBUG "${RDKAFKA_LIBRARY_DEBUG}")
    endif()

    if(NOT RDKAFKA_LIBRARY_RELEASE AND NOT RDKAFKA_LIBRARY_DEBUG)
      set_property(TARGET RDKAFKA::RDKAFKA APPEND PROPERTY
        IMPORTED_LOCATION "${RDKAFKA_LIBRARY}")
    endif()
  endif()
endif()



unset(RDKAFKA_NO_CONFIG)
unset(RDKAFKA_IS_HEADER_ONLY)
