
/*
 * SPDX-FileCopyrightText: Copyright (c) 2024, NVIDIA CORPORATION.
 * SPDX-License-Identifier: Apache-2.0
 */

/*
 * NOTE: this file is to be used in source files generated by
 * src/neighbors/detailivf_pq_compute_similarity_00_generate.py
 */

#pragma once

#include <raft/neighbors/detail/ivf_pq_compute_similarity-inl.cuh>
#include <raft/neighbors/detail/ivf_pq_fp_8bit.cuh>
#include <raft/neighbors/sample_filter.cuh>

#define instantiate_raft_neighbors_ivf_pq_detail_compute_similarity_select(                    \
  OutT, LutT, IvfSampleFilterT)                                                                \
  template auto                                                                                \
  raft::neighbors::ivf_pq::detail::compute_similarity_select<OutT, LutT, IvfSampleFilterT>(    \
    const cudaDeviceProp& dev_props,                                                           \
    bool manage_local_topk,                                                                    \
    int locality_hint,                                                                         \
    double preferred_shmem_carveout,                                                           \
    uint32_t pq_bits,                                                                          \
    uint32_t pq_dim,                                                                           \
    uint32_t precomp_data_count,                                                               \
    uint32_t n_queries,                                                                        \
    uint32_t n_probes,                                                                         \
    uint32_t topk) -> raft::neighbors::ivf_pq::detail::selected<OutT, LutT, IvfSampleFilterT>; \
                                                                                               \
  template void                                                                                \
  raft::neighbors::ivf_pq::detail::compute_similarity_run<OutT, LutT, IvfSampleFilterT>(       \
    raft::neighbors::ivf_pq::detail::selected<OutT, LutT, IvfSampleFilterT> s,                 \
    rmm::cuda_stream_view stream,                                                              \
    uint32_t dim,                                                                              \
    uint32_t n_probes,                                                                         \
    uint32_t pq_dim,                                                                           \
    uint32_t n_queries,                                                                        \
    uint32_t queries_offset,                                                                   \
    raft::distance::DistanceType metric,                                                       \
    raft::neighbors::ivf_pq::codebook_gen codebook_kind,                                       \
    uint32_t topk,                                                                             \
    uint32_t max_samples,                                                                      \
    const float* cluster_centers,                                                              \
    const float* pq_centers,                                                                   \
    const uint8_t* const* pq_dataset,                                                          \
    const uint32_t* cluster_labels,                                                            \
    const uint32_t* _chunk_indices,                                                            \
    const float* queries,                                                                      \
    const uint32_t* index_list,                                                                \
    float* query_kths,                                                                         \
    IvfSampleFilterT sample_filter,                                                            \
    LutT* lut_scores,                                                                          \
    OutT* _out_scores,                                                                         \
    uint32_t* _out_indices);

#define COMMA ,
