# Copyright (c) 2024-2025, NVIDIA CORPORATION.

from enum import IntEnum

from pylibcudf.column import Column
from pylibcudf.types import DataType

class UnaryOperator(IntEnum):
    SIN = ...
    COS = ...
    TAN = ...
    ARCSIN = ...
    ARCCOS = ...
    ARCTAN = ...
    SINH = ...
    COSH = ...
    TANH = ...
    ARCSINH = ...
    ARCCOSH = ...
    ARCTANH = ...
    EXP = ...
    LOG = ...
    SQRT = ...
    CBRT = ...
    CEIL = ...
    FLOOR = ...
    ABS = ...
    RINT = ...
    BIT_COUNT = ...
    BIT_INVERT = ...
    NOT = ...
    NEGATE = ...

def unary_operation(input: Column, op: UnaryOperator) -> Column: ...
def is_null(input: Column) -> Column: ...
def is_valid(input: Column) -> Column: ...
def cast(input: Column, data_type: DataType) -> Column: ...
def is_nan(input: Column) -> Column: ...
def is_not_nan(input: Column) -> Column: ...
def is_supported_cast(from_: DataType, to: DataType) -> bool: ...
