# SPDX-FileCopyrightText: Copyright (c) 2024-2025, NVIDIA CORPORATION.
# SPDX-License-Identifier: Apache-2.0
from rmm.pylibrmm.memory_resource import DeviceMemoryResource
from rmm.pylibrmm.stream import Stream

from pylibcudf.io.types import SourceInfo, TableWithMetadata

__all__ = ["AvroReaderOptions", "AvroReaderOptionsBuilder", "read_avro"]

class AvroReaderOptions:
    def set_columns(self, col_names: list[str]) -> None: ...
    def set_source(self, src: SourceInfo) -> None: ...
    @staticmethod
    def builder(source: SourceInfo) -> AvroReaderOptionsBuilder: ...

class AvroReaderOptionsBuilder:
    def columns(self, col_names: list[str]) -> AvroReaderOptionsBuilder: ...
    def skip_rows(self, skip_rows: int) -> AvroReaderOptionsBuilder: ...
    def num_rows(self, num_rows: int) -> AvroReaderOptionsBuilder: ...
    def build(self) -> AvroReaderOptions: ...

def read_avro(
    options: AvroReaderOptions,
    stream: Stream | None = None,
    mr: DeviceMemoryResource | None = None,
) -> TableWithMetadata: ...
