# SPDX-FileCopyrightText: Copyright (c) 2024-2026, NVIDIA CORPORATION.
# SPDX-License-Identifier: Apache-2.0

from collections.abc import Mapping, Sequence

from typing_extensions import Self

from rmm.pylibrmm.memory_resource import DeviceMemoryResource
from rmm.pylibrmm.stream import Stream

from pylibcudf.expressions import Expression
from pylibcudf.io.types import (
    CompressionType,
    DictionaryPolicy,
    PartitionInfo,
    SinkInfo,
    SourceInfo,
    StatisticsFreq,
    TableInputMetadata,
    TableWithMetadata,
)
from pylibcudf.table import Table

class ParquetReaderOptions:
    def __init__(self): ...
    def set_row_groups(self, row_groups: list[list[int]]): ...
    def set_num_rows(self, nrows: int): ...
    def set_skip_rows(self, skip_rows: int): ...
    def set_columns(self, col_names: list[str]): ...
    def set_filter(self, filter: Expression): ...
    def set_source(self, src: SourceInfo) -> None: ...
    def is_enabled_use_jit_filter(self) -> bool: ...
    @staticmethod
    def builder(source: SourceInfo) -> ParquetReaderOptionsBuilder: ...

class ParquetReaderOptionsBuilder:
    def __init__(self): ...
    def convert_strings_to_categories(self, val: bool) -> Self: ...
    def use_pandas_metadata(self, val: bool) -> Self: ...
    def allow_mismatched_pq_schemas(self, val: bool) -> Self: ...
    def ignore_missing_columns(self, val: bool) -> Self: ...
    def use_arrow_schema(self, val: bool) -> Self: ...
    def use_jit_filter(self, use_jit_filter: bool) -> Self: ...
    def build(self) -> ParquetReaderOptions: ...

class ChunkedParquetReader:
    def __init__(
        self,
        options: ParquetReaderOptions,
        stream: Stream | None = None,
        chunk_read_limit: int = 0,
        pass_read_limit: int = 1024000000,
    ) -> None: ...
    def has_next(self) -> bool: ...
    def read_chunk(self) -> TableWithMetadata: ...

def read_parquet(
    options: ParquetReaderOptions,
    stream: Stream | None = None,
    mr: DeviceMemoryResource | None = None,
) -> TableWithMetadata: ...

class ParquetWriterOptions:
    def __init__(self): ...
    @staticmethod
    def builder(
        sink: SinkInfo, table: Table
    ) -> ParquetWriterOptionsBuilder: ...
    def set_partitions(self, partitions: list[PartitionInfo]) -> None: ...
    def set_column_chunks_file_paths(
        self, file_paths: Sequence[str]
    ) -> None: ...
    def set_row_group_size_bytes(self, size_bytes: int) -> None: ...
    def set_row_group_size_rows(self, size_rows: int) -> None: ...
    def set_max_page_size_bytes(self, size_bytes: int) -> None: ...
    def set_max_page_size_rows(self, size_rows: int) -> None: ...
    def set_max_dictionary_size(self, size_bytes: int) -> None: ...

class ParquetWriterOptionsBuilder:
    def __init__(self): ...
    def metadata(self, metadata: TableInputMetadata) -> Self: ...
    def key_value_metadata(
        self, metadata: Sequence[Mapping[str, str]]
    ) -> Self: ...
    def compression(self, compression: CompressionType) -> Self: ...
    def stats_level(self, sf: StatisticsFreq) -> Self: ...
    def int96_timestamps(self, enabled: bool) -> Self: ...
    def write_v2_headers(self, enabled: bool) -> Self: ...
    def page_level_compression(self, enabled: bool) -> Self: ...
    def dictionary_policy(self, val: DictionaryPolicy) -> Self: ...
    def utc_timestamps(self, enabled: bool) -> Self: ...
    def write_arrow_schema(self, enabled: bool) -> Self: ...
    def row_group_size_rows(self, val: int) -> Self: ...
    def max_page_size_bytes(self, val: int) -> Self: ...
    def build(self) -> ParquetWriterOptions: ...

def write_parquet(
    options: ParquetWriterOptions, stream: Stream | None = None
) -> memoryview: ...
def is_supported_read_parquet(compression: CompressionType) -> bool: ...
def is_supported_write_parquet(compression: CompressionType) -> bool: ...

class ChunkedParquetWriter:
    def __init__(self): ...
    def close(self, metadata_file_path: list) -> memoryview: ...
    def write(self, table: Table, partitions_info: object = None) -> None: ...
    @staticmethod
    def from_options(
        options: ChunkedParquetWriterOptions, stream: Stream | None = None
    ) -> ChunkedParquetWriter: ...

class ChunkedParquetWriterOptions:
    def __init__(self): ...
    def set_dictionary_policy(self, policy: DictionaryPolicy) -> None: ...
    @staticmethod
    def builder(sink: SinkInfo) -> ChunkedParquetWriterOptionsBuilder: ...

class ChunkedParquetWriterOptionsBuilder:
    def __init__(self): ...
    def metadata(self, metadata: TableInputMetadata) -> Self: ...
    def key_value_metadata(
        self, metadata: Sequence[Mapping[str, str]]
    ) -> Self: ...
    def compression(self, compression: CompressionType) -> Self: ...
    def stats_level(self, sf: StatisticsFreq) -> Self: ...
    def row_group_size_bytes(self, val: int) -> Self: ...
    def row_group_size_rows(self, val: int) -> Self: ...
    def max_page_size_bytes(self, val: int) -> Self: ...
    def max_page_size_rows(self, val: int) -> Self: ...
    def max_dictionary_size(self, val: int) -> Self: ...
    def write_arrow_schema(self, enabled: bool) -> Self: ...
    def build(self) -> ChunkedParquetWriterOptions: ...

def merge_row_group_metadata(metdata_list: list) -> memoryview: ...
