# SPDX-FileCopyrightText: Copyright (c) 2025, NVIDIA CORPORATION & AFFILIATES.
# SPDX-License-Identifier: Apache-2.0

from __future__ import annotations

class MemoryDataPoint:
    @property
    def timestamp(self) -> float: ...
    @property
    def free_memory(self) -> int: ...
    @property
    def total_memory(self) -> int: ...
    @property
    def used_memory(self) -> int: ...
    def __repr__(self) -> str: ...

class CuptiMonitor:
    def __init__(
        self, enable_periodic_sampling: bool = ..., sampling_interval_ms: int = ...
    ) -> None: ...
    def start_monitoring(self) -> None: ...
    def stop_monitoring(self) -> None: ...
    def is_monitoring(self) -> bool: ...
    def capture_memory_sample(self) -> None: ...
    def get_memory_samples(self) -> list[MemoryDataPoint]: ...
    def clear_samples(self) -> None: ...
    def get_sample_count(self) -> int: ...
    def write_csv(self, filename: str) -> None: ...
    def set_debug_output(self, enabled: bool, threshold_mb: int = ...) -> None: ...
    def get_callback_counters(self) -> dict[int, int]: ...
    def clear_callback_counters(self) -> None: ...
    def get_total_callback_count(self) -> int: ...
    def get_callback_summary(self) -> str: ...
