# SPDX-FileCopyrightText: Copyright (c) 2025, NVIDIA CORPORATION & AFFILIATES.
# SPDX-License-Identifier: Apache-2.0

from enum import IntEnum

class LOG_LEVEL(IntEnum):
    NONE = ...
    PRINT = ...
    WARN = ...
    INFO = ...
    DEBUG = ...
    TRACE = ...

class Logger:
    @property
    def verbosity_level(self) -> LOG_LEVEL: ...
    def print(self, msg: str) -> None: ...
    def warn(self, msg: str) -> None: ...
    def info(self, msg: str) -> None: ...
    def debug(self, msg: str) -> None: ...
    def trace(self, msg: str) -> None: ...

class Communicator:
    @property
    def rank(self) -> int: ...
    @property
    def nranks(self) -> int: ...
    @property
    def logger(self) -> Logger: ...
    def get_str(self) -> str: ...

def _available_communicators() -> tuple[str, ...]: ...
