# SPDX-FileCopyrightText: Copyright (c) 2025, NVIDIA CORPORATION & AFFILIATES.
# SPDX-License-Identifier: Apache-2.0
from __future__ import annotations

from collections.abc import Callable, Mapping
from typing import Generic, TypeVar, overload

T = TypeVar("T")

# Types also accessible in C++.
CppType = TypeVar("CppType", bool, int, float, str)

class Options:
    def __init__(
        self,
        options_as_strings: Mapping[str, str] | None = None,
    ) -> None: ...
    def insert_if_absent(self, options_as_strings: Mapping[str, str]) -> int: ...
    @overload
    def get(
        self, key: str, *, return_type: type[CppType], factory: Callable[[str], CppType]
    ) -> CppType: ...
    @overload
    def get(
        self, key: str, *, return_type: type[object], factory: Callable[[str], T]
    ) -> T: ...
    def get_or_default(self, key: str, *, default_value: T) -> T: ...
    def get_strings(self) -> dict[str, str]: ...
    def serialize(self) -> bytes: ...
    @staticmethod
    def deserialize(serialized_buffer: bytes) -> Options: ...
    def __getstate__(self) -> bytes: ...
    def __setstate__(self, state: bytes) -> None: ...

class Optional(Generic[T]):
    def __init__(self, value: T) -> None: ...
    @property
    def value(self) -> T | None: ...

class OptionalBytes(Optional): ...

def get_environment_variables(key_regex: str = ...) -> dict[str, str]: ...
