import logging
import os

from traitlets.config import Application


class CustomLogger:
    jlab_logger = Application.instance().log
    general_logger = logging.getLogger(__name__)

    def __init__(self):
        if log_level := int(os.getenv("LOG_LEVEL", logging.INFO)):
            Application.log_level = log_level
            self.general_logger.setLevel(log_level)

    def _log(self, log_type: str, msg: str):
        getattr(self.jlab_logger, f"{log_type}")(msg)
        getattr(self.general_logger, f"{log_type}")(msg)

    def _unset_loggers(self):
        self.jlab_logger = None
        self.general_logger = None

    def info(self, msg: str):
        self._log("info", msg)

    def warning(self, msg: str):
        self._log("warning", msg)

    def error(self, msg: str):
        self._log("error", msg)

    def debug(self, msg: str):
        self._log("debug", msg)

    def exception(self, msg: str):
        self._log("exception", msg)


logger = CustomLogger()
