from typing import Dict, Optional, Tuple

import httpx

from aext_core_server.exceptions import UserFeaturesException
from aext_shared.consts import RequestMethods, UserAccessCredentials
from aext_shared.errors import BackendError
from aext_shared.request_utils import anaconda_cloud_request


class UserService:
    async def list_features(self, user_credentials: UserAccessCredentials) -> Tuple[int, Optional[Dict]]:
        try:
            response = await anaconda_cloud_request("account/features", RequestMethods.GET, user_credentials)
            if response.status_code == httpx.codes.OK:
                return response.status_code, response.json()
            return response.status_code, None
        except BackendError:
            raise UserFeaturesException


user_service = UserService()
