from typing import Any, Optional

from .schemas import MetaResponse, RequestError, ServiceResponse
from .utils import to_json


def create_response(
    status: bool = False,
    message: str = "",
    content: Optional[Any] = "",
    json_response=True,
):
    err = RequestError(status=status, message=message)
    response = ServiceResponse(meta=MetaResponse(error=err), content=content)
    if not json_response:
        return response

    return to_json(response)
