from dataclasses import dataclass
from io import BytesIO
from uuid import UUID


@dataclass
class CreateProject:
    user_id: str
    title: str
    version: str
    environment: str
    notebook_file_name: str
    notebook_file_size: str
    permission: str
    description: str = ""


@dataclass
class UpdateProject:
    title: str
    description: str = ""


@dataclass
class CreateProjectVersion:
    project_id: UUID
    version: str
    environment: str
    notebook_file_name: str
    notebook_file_size: str
