import aext_project_filebrowser_server as project_filebrowser

from ._version import __version__


def _jupyter_labextension_paths():
    return [{"src": "labextension", "dest": "@anaconda/toolbox"}]


def _jupyter_server_extension_points():
    return [{"module": "aext_toolbox"}]


def _load_jupyter_server_extension(server_app):
    web_app = server_app.web_app
    base_url = web_app.settings["base_url"]
    routes = project_filebrowser.get_routes(base_url)
    web_app.add_handlers(".*$", routes)
    server_app.log.info("Registered aext_project_filebrowser_server extension")
    server_app.log.info("Registered aext_toolbox extension")


load_jupyter_server_extension = _load_jupyter_server_extension
