# Copyright 2020 The AutoKeras Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
import keras

from autokeras.preprocessors.common import AddOneDimension
from autokeras.preprocessors.common import CastToInt32
from autokeras.preprocessors.common import CastToString
from autokeras.preprocessors.common import TextTokenizer
from autokeras.preprocessors.encoders import CategoricalToNumerical
from autokeras.preprocessors.encoders import LabelEncoder
from autokeras.preprocessors.encoders import OneHotEncoder
from autokeras.preprocessors.postprocessors import SigmoidPostprocessor
from autokeras.preprocessors.postprocessors import SoftmaxPostprocessor
from autokeras.utils import utils


def serialize(preprocessor):
    return utils.serialize_keras_object(preprocessor)


def deserialize(config, custom_objects=None):
    return utils.deserialize_keras_object(
        config,
        module_objects=globals(),
        custom_objects=custom_objects,
    )
