# Copyright 2020 The AutoKeras Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import shutil

import keras
import pytest


@pytest.fixture(autouse=True)
def clear_session():
    keras.backend.clear_session()
    yield
    keras.backend.clear_session()


@pytest.fixture(autouse=True)
def remove_tmp_path(tmp_path):
    yield
    shutil.rmtree(tmp_path)


@pytest.fixture(autouse=True)
def disable_traceback_filtering():
    keras.config.disable_traceback_filtering()
    yield
