set -euxo pipefail

"${PYTHON}" "${RECIPE_DIR}/copy_patches.py"\
    --patch-source "${SRC_DIR}/src/conda_patches"\
    --site-packages "${SP_DIR}"\
    --conda-source conda_src

# make sure pyinstaller finds Apple's codesign first in PATH
# some base installations have 'sigtool', which ships a
# 'codesign' binary that might shadow Apple's codesign
if [[ $target_platform == osx-* ]]; then
  ln -s /usr/bin/codesign "$BUILD_PREFIX/bin/codesign"
fi

# -F is to create a single file
# -s strips executables and libraries
export variant="$variant"
pyinstaller --clean --log-level=DEBUG src/conda.exe.spec
if [[ "$variant" == "onedir" ]]; then
  mkdir -p "$PREFIX"
else
  mkdir -p "$PREFIX/standalone_conda"
fi
mv dist/conda.exe "$PREFIX/standalone_conda"

# Collect licenses
python src/licenses.py \
  --prefix "$BUILD_PREFIX" \
  --include-text \
  --text-errors replace \
  --output "$SRC_DIR/3rd-party-licenses.json"

# clean up .pyc files that pyinstaller creates
rm -rf "$PREFIX/lib"

if [[ $target_platform == osx-* ]]; then
  rm "$BUILD_PREFIX/bin/codesign"
fi
