'use strict';
/*!
 * Copyright (c) Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], undefined);
})(this, function(Bokeh, version) {
  let define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" ? (version != null ? Bokeh[version] : Bokeh) : null;
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh" + (version != null ? " " + version : "") + ". You have to load it prior to loading plugins.");
    }
  })
({
"c764d38756": function _(e,s,o,t,b){t();const i=e("tslib").__importStar(e("2e3df39bba"));o.GeoViews=i;(0,e("@bokehjs/base").register_models)(i)},
"2e3df39bba": function _(o,e,l,d,r){d(),r("CheckpointTool",o("49636d3eef").CheckpointTool),r("ClearTool",o("356402dee7").ClearTool),r("PolyVertexDrawTool",o("c03d81e6d5").PolyVertexDrawTool),r("PolyVertexEditTool",o("238deef1f5").PolyVertexEditTool),r("RestoreTool",o("1a96add9eb").RestoreTool),r("WindBarb",o("028985dc77").WindBarb)},
"49636d3eef": function _(o,e,s,t,c){var n;t();const i=o("@bokehjs/core/util/object"),r=o("@bokehjs/core/util/array"),l=o("@bokehjs/models/tools/actions/action_tool"),u=o("@bokehjs/models/sources/column_data_source"),_=o("@bokehjs/styles/icons.css");class a extends l.ActionToolView{doit(){const o=this.model.sources;for(const e of o){null==e.buffer&&(e.buffer=[]);const o={};for(const[s,t]of(0,i.entries)(e.data)){const e=[];for(const o of t)Array.isArray(o)||ArrayBuffer.isView(o)?e.push((0,r.copy)(o)):e.push(o);o[s]=e}e.buffer.push(o)}}}s.CheckpointToolView=a,a.__name__="CheckpointToolView";class f extends l.ActionTool{constructor(o){super(o),this.tool_name="Checkpoint",this.tool_icon=_.tool_icon_save}}s.CheckpointTool=f,n=f,f.__name__="CheckpointTool",f.__module__="geoviews.models.custom_tools",n.prototype.default_view=a,n.define((({List:o,Ref:e})=>({sources:[o(e(u.ColumnDataSource)),[]]})))},
"356402dee7": function _(o,e,s,t,l){var c;t();const _=o("@bokehjs/models/tools/actions/action_tool"),a=o("@bokehjs/models/sources/column_data_source"),n=o("@bokehjs/styles/icons.css");class i extends _.ActionToolView{doit(){for(const o of this.model.sources)o.clear()}}s.ClearToolView=i,i.__name__="ClearToolView";class r extends _.ActionTool{constructor(o){super(o),this.tool_name="Clear data",this.tool_icon=n.tool_icon_reset}}s.ClearTool=r,c=r,r.__name__="ClearTool",r.__module__="geoviews.models.custom_tools",c.prototype.default_view=i,c.define((({List:o,Ref:e})=>({sources:[o(e(a.ColumnDataSource)),[]]})))},
"c03d81e6d5": function _(e,s,t,o,r){var l;o();const i=e("@bokehjs/core/vectorization"),n=e("@bokehjs/core/util/object"),c=e("@bokehjs/core/util/types"),a=e("@bokehjs/core/util/assert"),_=e("@bokehjs/models/tools/edit/poly_draw_tool");class d extends _.PolyDrawToolView{_split_path(e,s){for(const t of this.model.renderers){const o=t.glyph,r=t.data_source,[l,i]=[o.xs.field,o.ys.field],n=r.data[l],a=r.data[i];for(let t=0;t<n.length;t++){let o=n[t];(0,c.isArray)(o)||(o=Array.from(o),r.data[l][t]=o);let _=a[t];(0,c.isArray)(_)||(_=Array.from(_),r.data[i][t]=_);for(let c=0;c<o.length;c++)if(o[c]==e&&_[c]==s&&0!=c&&c!=o.length-1){n.splice(t+1,0,o.slice(c)),a.splice(t+1,0,_.slice(c)),o.splice(c+1),_.splice(c+1);for(const e of r.columns())e!==l&&e!=i&&r.data[e].splice(t+1,0,r.data[e][t]);return}}}}_snap_to_vertex(e,s,t){const{vertex_renderer:o}=this.model;if(null!=o){const r=this._select_event(e,"replace",[o]),l=o.data_source,i=o.glyph,[n,c]=[i.x.field,i.y.field];if(r.length>0){const o=l.selected.indices[0];n&&(s=l.get(n)[o]),c&&(t=l.get(c)[o]),"move"!=e.type&&this._split_path(s,t),l.selection_manager.clear()}}return[s,t]}_set_vertices(e,s,t){const{vertex_renderer:o}=this.model;if(null==o)return;const r=o.glyph,l=o.data_source,[i,a]=[r.x.field,r.y.field];if(i&&((0,c.isArray)(e)?l.set(i,e):r.x={value:e}),a&&((0,c.isArray)(s)?l.set(a,s):r.y={value:s}),null!=t)for(const e of(0,n.keys)(t))l.set(e,t[e]),r[e]={field:e};else for(const e of l.columns())l.set(e,[]);this._emit_cds_changes(l,!0,!0,!1)}_show_vertices(){if(!this.model.active)return;const{renderers:e,node_style:s,end_style:t}=this.model,o=[],r=[],l={};for(const e of(0,n.keys)(t))l[e]=[];for(let i=0;i<e.length;i++){const _=e[i],d=_.data_source,f=_.glyph,[h,y]=[f.xs.field,f.ys.field];for(const e of d.get_array(h)){(0,a.assert)((0,c.isArray)(e)),o.push(...e);for(const[e,s]of(0,n.entries)(t))l[e].push(s);for(const[t,o]of(0,n.entries)(s))for(let s=0;s<e.length-2;s++)l[t].push(o);for(const[e,s]of(0,n.entries)(t))l[e].push(s)}for(const e of d.get_array(y))(0,a.assert)((0,c.isArray)(e)),r.push(...e);if(this._drawing&&i==e.length-1){o.splice(o.length-1,1),r.splice(r.length-1,1);for(const[e,s]of(0,n.entries)(l))s.splice(s.length-1,1)}}this._set_vertices(o,r,l)}_remove(){const e=this.model.renderers[0],s=e.data_source,t=e.glyph;if((0,i.isField)(t.xs)){const e=t.xs.field,o=s.get_array(e),r=o.length-1,l=o[r];l.splice(l.length-1,1),1==l.length&&o.splice(r,1)}if((0,i.isField)(t.ys)){const e=t.ys.field,o=s.get_array(e),r=o.length-1,l=o[r];l.splice(l.length-1,1),1==l.length&&o.splice(r,1)}this._emit_cds_changes(s),this._drawing=!1,this._show_vertices()}}t.PolyVertexDrawToolView=d,d.__name__="PolyVertexDrawToolView";class f extends _.PolyDrawTool{constructor(e){super(e)}}t.PolyVertexDrawTool=f,l=f,f.__name__="PolyVertexDrawTool",f.__module__="geoviews.models.custom_tools",l.prototype.default_view=d,l.define((({Dict:e,Unknown:s})=>({end_style:[e(s),{}],node_style:[e(s),{}]})))},
"238deef1f5": function _(e,t,s,r,i){var n;r();const o=e("@bokehjs/core/util/object"),_=e("@bokehjs/core/util/types"),l=e("@bokehjs/models/tools/edit/poly_edit_tool");class d extends l.PolyEditToolView{deactivate(){this._hide_vertices(),null!=this._selected_renderer&&(this._drawing&&(this._remove_vertex(),this._drawing=!1),this._emit_cds_changes(this._selected_renderer.data_source,!1,!0,!1))}_pan(e){if(null==this._basepoint||null==this.model.vertex_renderer)return;const t=this._drag_points(e,[this.model.vertex_renderer]);e.modifiers.shift||this._move_linked(t),null!=this._selected_renderer&&this._selected_renderer.data_source.change.emit()}_pan_end(e){if(null==this._basepoint||null==this.model.vertex_renderer)return;const t=this._drag_points(e,[this.model.vertex_renderer]);e.modifiers.shift||this._move_linked(t),this._emit_cds_changes(this.model.vertex_renderer.data_source,!1,!0,!0),null!=this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null}_drag_points(e,t){if(null==this._basepoint)return[];const[s,r]=this._basepoint,i=[];for(const n of t){const t=this._map_drag(s,r,n),o=this._map_drag(e.sx,e.sy,n);if(null==o||null==t)continue;const[_,l]=o,[d,c]=t,[h,a]=[_-d,l-c],u=n.glyph,f=n.data_source,[m,g]=[u.x.field,u.y.field];for(const e of f.selected.indices){const t=[];if(m){const s=f.get(m);t.push(s[e]),s[e]+=h}if(g){const s=f.get(g);t.push(s[e]),s[e]+=a}t.push(h),t.push(a),i.push(t)}f.change.emit()}return this._basepoint=[e.sx,e.sy],i}_set_vertices(e,t,s){if(null==this.model.vertex_renderer)return;const r=this.model.vertex_renderer.glyph,i=this.model.vertex_renderer.data_source,[n,l]=[r.x.field,r.y.field];if(n&&((0,_.isArray)(e)?i.set(n,e):r.x={value:e}),l&&((0,_.isArray)(t)?i.set(l,t):r.y={value:t}),null!=s)for(const[e,t]of(0,o.entries)(s))i.set(e,t),r[e]={field:e};else for(const e of i.columns())i.set(e,[]);this._emit_cds_changes(i,!0,!0,!1)}_move_linked(e){if(null==this._selected_renderer)return;const t=this._selected_renderer,s=t.glyph,r=t.data_source,[i,n]=[s.xs.field,s.ys.field],o=r.data[i],_=r.data[n];for(const t of e){const[e,s,r,i]=t;for(let t=0;t<o.length;t++){const n=o[t],l=_[t];for(let t=0;t<n.length;t++)n[t]==e&&l[t]==s&&(n[t]+=r,l[t]+=i)}}}_tap(e){if(null==this.model.vertex_renderer)return;const t=this.model.vertex_renderer,s=this._map_drag(e.sx,e.sy,t);if(null!=s){if(this._drawing&&null!=this._selected_renderer){let[r,i]=s;const n=t.data_source,o=t.glyph,[_,l]=[o.x.field,o.y.field],d=n.selected.indices;[r,i]=this._snap_to_vertex(e,r,i);const c=d[0];if(n.selected.indices=[c+1],_){const e=n.get_array(_),t=e[c];e[c]=r,e.splice(c+1,0,t)}if(l){const e=n.get_array(l),t=e[c];e[c]=i,e.splice(c+1,0,t)}return n.change.emit(),void this._emit_cds_changes(this._selected_renderer.data_source,!0,!1,!0)}this._select_event(e,this._select_mode(e),[t])}}_show_vertices(e){if(!this.model.active)return;const t=this._select_event(e,"replace",this.model.renderers);if(0===t.length)return this._hide_vertices(),this._selected_renderer=null,void(this._drawing=!1);const s=t[0],r=s.glyph,i=s.data_source,n=i.selected.indices[0],[l,d]=[r.xs.field,r.ys.field];let c,h;l?(c=i.get(l)[n],(0,_.isArray)(c)||(i.get(l)[n]=c=Array.from(c))):c=r.xs.value,d?(h=i.get(d)[n],(0,_.isArray)(h)||(i.get(d)[n]=h=Array.from(h))):h=r.ys.value;const{end_style:a,node_style:u}=this.model,f={};for(const[e,t]of(0,o.entries)(a))f[e]=[t];for(const[e,t]of(0,o.entries)(u))for(let s=0;s<c.length-2;s++)f[e].push(t);for(const[e,t]of(0,o.entries)(a))f[e].push(t);this._selected_renderer=s,this._set_vertices(c,h,f)}}s.PolyVertexEditToolView=d,d.__name__="PolyVertexEditToolView";class c extends l.PolyEditTool{constructor(e){super(e)}}s.PolyVertexEditTool=c,n=c,c.__name__="PolyVertexEditTool",c.__module__="geoviews.models.custom_tools",n.prototype.default_view=d,n.define((({Dict:e,Unknown:t})=>({end_style:[e(t),{}],node_style:[e(t),{}]})))},
"1a96add9eb": function _(o,e,s,t,c){var n;t();const l=o("@bokehjs/models/tools/actions/action_tool"),i=o("@bokehjs/models/sources/column_data_source"),_=o("@bokehjs/styles/icons.css");class a extends l.ActionToolView{doit(){const o=this.model.sources;for(const e of o){const o=e.buffer?.pop();null!=o&&(e.data=o,e.change.emit(),e.properties.data.change.emit())}}}s.RestoreToolView=a,a.__name__="RestoreToolView";class r extends l.ActionTool{constructor(o){super(o),this.tool_name="Restore",this.tool_icon=_.tool_icon_undo}}s.RestoreTool=r,n=r,r.__name__="RestoreTool",r.__module__="geoviews.models.custom_tools",n.prototype.default_view=a,n.define((({List:o,Ref:e})=>({sources:[o(e(i.ColumnDataSource)),[]]})))},
"028985dc77": function _(e,t,i,s,o){var n;s();const l=e("tslib"),a=e("@bokehjs/models/glyphs/xy_glyph"),r=e("@bokehjs/core/property_mixins"),_=l.__importStar(e("@bokehjs/core/properties")),d=e("@bokehjs/models/selections/selection");class h extends a.XYGlyphView{_paint(e,t,i){const{sx:s,sy:o,angle:n,magnitude:l}=i??this,a=this.y,r=this.model.scale;for(const i of t){const t=s[i],_=o[i],d=n.get(i),h=l.get(i),c=a[i];isFinite(t+_+d+h+c)&&this._draw_wind_barb(e,t,_,d,h,r,i)}}_draw_wind_barb(e,t,i,s,o,n,l=0){const a=this.model.barb_length*n,r=this.model.barb_width*n,_=this.model.flag_width*n;e.save(),e.translate(t,i),e.rotate(-s),e.beginPath(),this.visuals.line.apply(e,l),e.strokeStyle=e.strokeStyle||"black",e.lineCap="round",e.lineJoin="round";const d=5*Math.round(o/5);if(d>=5){e.moveTo(0,0),e.lineTo(0,-a),e.stroke();let t=d,i=-a;const s=this.model.spacing*n;for(;t>=50;)e.fillStyle=e.strokeStyle||"black",e.beginPath(),e.moveTo(0,i),e.lineTo(_,i+s),e.lineTo(0,i+2*s),e.closePath(),e.fill(),i+=2.5*s,t-=50;for(;t>=10;)e.beginPath(),e.moveTo(0,i),e.lineTo(r,i+.2*r),e.stroke(),i+=s,t-=10;t>=5&&(e.beginPath(),e.moveTo(0,i),e.lineTo(r/2,i+.1*r),e.stroke())}else e.beginPath(),e.arc(0,0,this.model.calm_circle_radius*n,0,2*Math.PI),e.stroke();e.restore()}_hit_point(e){const{sx:t,sy:i}=e,s=[];for(let e=0;e<this.data_size;e++){const o=this.sx[e]-t,n=this.sy[e]-i;Math.sqrt(o*o+n*n)<10*this.model.scale&&s.push(e)}return new d.Selection({indices:s})}draw_legend_for_index(e,{x0:t,x1:i,y0:s,y1:o},n){const l=(t+i)/2,a=(s+o)/2;this._draw_wind_barb(e,l,a,Math.PI/4,25,.5)}}i.WindBarbView=h,h.__name__="WindBarbView";class c extends a.XYGlyph{constructor(e){super(e)}}i.WindBarb=c,n=c,c.__name__="WindBarb",c.__module__="geoviews.models.wind_barb",n.prototype.default_view=h,n.define((({Float:e})=>({angle:[_.AngleSpec,{value:0}],magnitude:[_.NumberSpec,{value:0}],scale:[e,1],barb_length:[e,30],barb_width:[e,15],flag_width:[e,15],spacing:[e,6],calm_circle_radius:[e,3]}))),n.mixins(r.LineVector)},
}, "c764d38756", {"index":"c764d38756","models/index":"2e3df39bba","models/checkpoint_tool":"49636d3eef","models/clear_tool":"356402dee7","models/poly_draw":"c03d81e6d5","models/poly_edit":"238deef1f5","models/restore_tool":"1a96add9eb","models/wind_barb":"028985dc77"}, {});});
