# coding: utf-8
"""
    Snowflake API Integration API.

    The Snowflake API Integration API is a REST API that you can use to access, update, and perform certain actions on API Integration resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.api_integration._generated.models.api_hook import ApiHook

from datetime import datetime

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator

from typing import Any, ClassVar, Dict, List, Optional

from typing_extensions import Annotated


class ApiIntegration(BaseModel):
    """A model object representing the ApiIntegration resource.

    Constructs an object of type ApiIntegration with the provided properties.

    Parameters
    __________
    name : str
        Name of the API integration.
    api_hook : ApiHook

    api_allowed_prefixes : List[str]
        A comma-separated list of endpoints and resources that Snowflake can access.
    enabled : bool
        Whether the API integration is enabled.
    api_blocked_prefixes : List[str], optional
        A comma-separated list of endpoints and resources that are not allowed to be called from Snowflake.
    comment : str, optional
        Comment for the API integration.
    created_on : datetime, optional
        Date and time when the API integration was created.
    """

    name: Annotated[str, Field(strict=True)]

    api_hook: ApiHook

    api_allowed_prefixes: List[StrictStr]

    api_blocked_prefixes: Optional[List[StrictStr]] = None

    enabled: StrictBool

    comment: Optional[StrictStr] = None

    created_on: Optional[datetime] = None

    __properties = [
        "name", "api_hook", "api_allowed_prefixes", "api_blocked_prefixes",
        "enabled", "comment", "created_on"
    ]

    @field_validator('name')
    def name_validate_regular_expression(cls, v):

        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiIntegration:
        """Create an instance of ApiIntegration from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({
                "created_on",
            })

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of api_hook
        if self.api_hook:
            _dict['api_hook'] = self.api_hook.to_dict()

        # set to None if api_blocked_prefixes (nullable) is None
        if self.api_blocked_prefixes is None:
            _dict['api_blocked_prefixes'] = None

        # set to None if comment (nullable) is None
        if self.comment is None:
            _dict['comment'] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ApiIntegration:
        """Create an instance of ApiIntegration from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return ApiIntegration.parse_obj(obj)

        _obj = ApiIntegration.parse_obj({
            "name":
            obj.get("name"),
            "api_hook":
            ApiHook.from_dict(obj.get("api_hook"))
            if obj.get("api_hook") is not None else None,
            "api_allowed_prefixes":
            obj.get("api_allowed_prefixes"),
            "api_blocked_prefixes":
            obj.get("api_blocked_prefixes"),
            "enabled":
            obj.get("enabled"),
            "comment":
            obj.get("comment"),
            "created_on":
            obj.get("created_on"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.api_integration._generated.models.api_hook import ApiHook


class ApiIntegrationModel():

    def __init__(
        self,
        name: str,
        api_hook: ApiHook,
        api_allowed_prefixes: List[str],
        enabled: bool,
        # optional properties
        api_blocked_prefixes: Optional[List[str]] = None,
        comment: Optional[str] = None,
        created_on: Optional[datetime] = None,
    ):
        """A model object representing the ApiIntegration resource.

        Constructs an object of type ApiIntegration with the provided properties.

        Parameters
        __________
        name : str
            Name of the API integration.
        api_hook : ApiHook

        api_allowed_prefixes : List[str]
            A comma-separated list of endpoints and resources that Snowflake can access.
        enabled : bool
            Whether the API integration is enabled.
        api_blocked_prefixes : List[str], optional
            A comma-separated list of endpoints and resources that are not allowed to be called from Snowflake.
        comment : str, optional
            Comment for the API integration.
        created_on : datetime, optional
            Date and time when the API integration was created.
        """

        self.name = name
        self.api_hook = api_hook
        self.api_allowed_prefixes = api_allowed_prefixes
        self.api_blocked_prefixes = api_blocked_prefixes
        self.enabled = enabled
        self.comment = comment
        self.created_on = created_on

    __properties = [
        "name", "api_hook", "api_allowed_prefixes", "api_blocked_prefixes",
        "enabled", "comment", "created_on"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ApiIntegration(
            name=self.name,
            api_hook=self.api_hook._to_model()
            if self.api_hook is not None else None,
            api_allowed_prefixes=self.api_allowed_prefixes,
            api_blocked_prefixes=self.api_blocked_prefixes,
            enabled=self.enabled,
            comment=self.comment,
            created_on=self.created_on,
        )

    @classmethod
    def _from_model(cls, model) -> ApiIntegrationModel:
        return ApiIntegrationModel(
            name=model.name,
            api_hook=ApiHookModel._from_model(model.api_hook)
            if model.api_hook is not None else None,
            api_allowed_prefixes=model.api_allowed_prefixes,
            api_blocked_prefixes=model.api_blocked_prefixes,
            enabled=model.enabled,
            comment=model.comment,
            created_on=model.created_on,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a ApiIntegration.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ApiIntegration object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ApiIntegrationModel:
        """Creates an instance of ApiIntegration from a dict.

        This method constructs a ApiIntegration object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ApiIntegration
            A ApiIntegration object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ApiIntegration.from_dict(obj))


ApiIntegration._model_class = ApiIntegrationModel
