# coding: utf-8
"""
    Snowflake Catalog Integration API.

    The Snowflake Catalog Integration API is a REST API that you can use to access, update, and perform certain actions on Catalog Integration resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.catalog_integration._generated.models.rest_authentication import RestAuthentication

from pydantic import ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List


class OAuth(RestAuthentication):
    """A model object representing the OAuth resource.

    Constructs an object of type OAuth with the provided properties.

    Parameters
    __________
    oauth_client_id : str
        The client ID of the OAuth2 credential associated with the Polaris service connection.
    oauth_client_secret : str
        The secret for the OAuth2 credential associated with the Polaris service connection.
    oauth_allowed_scopes : List[str]
        The scope of the OAuth token. Only one scope is included in the Iceberg REST API specification, but catalogs can support more than one scope in their implementation.
    """

    oauth_client_id: StrictStr

    oauth_client_secret: StrictStr

    oauth_allowed_scopes: List[StrictStr]

    __properties = ["type"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OAuth:
        """Create an instance of OAuth from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        _dict['type'] = RestAuthentication.get_child_model_discriminator_value(
            'OAuth')

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> OAuth:
        """Create an instance of OAuth from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return OAuth.parse_obj(obj)

        _obj = OAuth.parse_obj({
            "oauth_client_id":
            obj.get("oauth_client_id"),
            "oauth_client_secret":
            obj.get("oauth_client_secret"),
            "oauth_allowed_scopes":
            obj.get("oauth_allowed_scopes"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.catalog_integration._generated.models.rest_authentication import RestAuthentication


class OAuthModel(RestAuthentication):

    def __init__(
        self,
        oauth_client_id: str,
        oauth_client_secret: str,
        oauth_allowed_scopes: List[str],
        # optional properties
    ):
        """A model object representing the OAuth resource.

        Constructs an object of type OAuth with the provided properties.

        Parameters
        __________
        oauth_client_id : str
            The client ID of the OAuth2 credential associated with the Polaris service connection.
        oauth_client_secret : str
            The secret for the OAuth2 credential associated with the Polaris service connection.
        oauth_allowed_scopes : List[str]
            The scope of the OAuth token. Only one scope is included in the Iceberg REST API specification, but catalogs can support more than one scope in their implementation.
        """

        super().__init__()
        self.oauth_client_id = oauth_client_id
        self.oauth_client_secret = oauth_client_secret
        self.oauth_allowed_scopes = oauth_allowed_scopes

    __properties = ["type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return OAuth(
            oauth_client_id=self.oauth_client_id,
            oauth_client_secret=self.oauth_client_secret,
            oauth_allowed_scopes=self.oauth_allowed_scopes,
        )

    @classmethod
    def _from_model(cls, model) -> OAuthModel:
        return OAuthModel(
            oauth_client_id=model.oauth_client_id,
            oauth_client_secret=model.oauth_client_secret,
            oauth_allowed_scopes=model.oauth_allowed_scopes,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a OAuth.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the OAuth object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> OAuthModel:
        """Creates an instance of OAuth from a dict.

        This method constructs a OAuth object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        OAuth
            A OAuth object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(OAuth.from_dict(obj))


OAuth._model_class = OAuthModel
