# coding: utf-8
"""
    Cortex Inference API.

    OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class GetModelsRequest(BaseModel):
    """A model object representing the GetModelsRequest resource.

    Constructs an object of type GetModelsRequest with the provided properties.

    Parameters
    __________
    models : List[str], optional
    """

    models: Optional[List[StrictStr]] = None

    __properties = ["models"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetModelsRequest:
        """Create an instance of GetModelsRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> GetModelsRequest:
        """Create an instance of GetModelsRequest from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return GetModelsRequest.parse_obj(obj)

        _obj = GetModelsRequest.parse_obj({
            "models": obj.get("models"),
        })

        return _obj


from typing import Optional, List, Dict


class GetModelsRequestModel():

    def __init__(
        self,  # optional properties
        models: Optional[List[str]] = None,
    ):
        """A model object representing the GetModelsRequest resource.

        Constructs an object of type GetModelsRequest with the provided properties.

        Parameters
        __________
        models : List[str], optional
        """

        self.models = models

    __properties = ["models"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return GetModelsRequest(models=self.models, )

    @classmethod
    def _from_model(cls, model) -> GetModelsRequestModel:
        return GetModelsRequestModel(models=model.models, )

    def to_dict(self):
        """Creates a dictionary of the properties from a GetModelsRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the GetModelsRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> GetModelsRequestModel:
        """Creates an instance of GetModelsRequest from a dict.

        This method constructs a GetModelsRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        GetModelsRequest
            A GetModelsRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(GetModelsRequest.from_dict(obj))


GetModelsRequest._model_class = GetModelsRequestModel
