# coding: utf-8
"""
    Cortex Inference API.

    OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class NonStreamingCompleteResponseChoicesInnerMessage(BaseModel):
    """A model object representing the NonStreamingCompleteResponseChoicesInnerMessage resource.

    Constructs an object of type NonStreamingCompleteResponseChoicesInnerMessage with the provided properties.

    Parameters
    __________
    content : str, optional
        The text completion response.
    content_list : List[object], optional
        Contents of text and toolUse response.
    """

    content: Optional[StrictStr] = None

    content_list: Optional[List[Any]] = None

    __properties = ["content", "content_list"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(
            cls,
            json_str: str) -> NonStreamingCompleteResponseChoicesInnerMessage:
        """Create an instance of NonStreamingCompleteResponseChoicesInnerMessage from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(
            cls, obj: dict) -> NonStreamingCompleteResponseChoicesInnerMessage:
        """Create an instance of NonStreamingCompleteResponseChoicesInnerMessage from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return NonStreamingCompleteResponseChoicesInnerMessage.parse_obj(
                obj)

        _obj = NonStreamingCompleteResponseChoicesInnerMessage.parse_obj({
            "content":
            obj.get("content"),
            "content_list":
            obj.get("content_list"),
        })

        return _obj


from typing import Optional, List, Dict


class NonStreamingCompleteResponseChoicesInnerMessageModel():

    def __init__(
        self,  # optional properties
        content: Optional[str] = None,
        content_list: Optional[List[object]] = None,
    ):
        """A model object representing the NonStreamingCompleteResponseChoicesInnerMessage resource.

        Constructs an object of type NonStreamingCompleteResponseChoicesInnerMessage with the provided properties.

        Parameters
        __________
        content : str, optional
            The text completion response.
        content_list : List[object], optional
            Contents of text and toolUse response.
        """

        self.content = content
        self.content_list = content_list

    __properties = ["content", "content_list"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return NonStreamingCompleteResponseChoicesInnerMessage(
            content=self.content,
            content_list=self.content_list,
        )

    @classmethod
    def _from_model(
            cls,
            model) -> NonStreamingCompleteResponseChoicesInnerMessageModel:
        return NonStreamingCompleteResponseChoicesInnerMessageModel(
            content=model.content,
            content_list=model.content_list,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a NonStreamingCompleteResponseChoicesInnerMessage.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the NonStreamingCompleteResponseChoicesInnerMessage object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(
            cls,
            obj: dict) -> NonStreamingCompleteResponseChoicesInnerMessageModel:
        """Creates an instance of NonStreamingCompleteResponseChoicesInnerMessage from a dict.

        This method constructs a NonStreamingCompleteResponseChoicesInnerMessage object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        NonStreamingCompleteResponseChoicesInnerMessage
            A NonStreamingCompleteResponseChoicesInnerMessage object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(
            NonStreamingCompleteResponseChoicesInnerMessage.from_dict(obj))


NonStreamingCompleteResponseChoicesInnerMessage._model_class = NonStreamingCompleteResponseChoicesInnerMessageModel
