# coding: utf-8
"""
    Cortex Agent API.

    OpenAPI 3.0 specification for the Cortex Agent API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.cortex.lite_agent_service._generated.models.message import Message

from snowflake.core.cortex.lite_agent_service._generated.models.tool import Tool

from snowflake.core.cortex.lite_agent_service._generated.models.tool_choice import ToolChoice

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr

from typing import Any, ClassVar, Dict, List, Optional

from typing_extensions import Annotated


class AgentRunRequest(BaseModel):
    """A model object representing the AgentRunRequest resource.

    Constructs an object of type AgentRunRequest with the provided properties.

    Parameters
    __________
    model : str
        The identifier of the LLM to use for processing.
    messages : List[Message]
        The conversation history and current message.
        Contains both user queries and assistant responses in chronological order.
    response_instruction : str, optional
        Optional instructions to guide the model's response style and behavior.
        Can be used to set the tone, format, or specific requirements for responses.
    experimental : object, optional
        reserved
    tools : List[Tool], optional
        List of tools available for the agent to use.
        Tools may have a corresponding configuration in tool_resources.
    tool_resources : Dict[str, object], optional
        Configuration for each tool referenced in the tools array.
        Keys must match the name field of tools.
    tool_choice : ToolChoice, optional

    thread_id : int, optional
        The id of the thread.
    parent_message_id : int, optional
        The id of the message from which this run should begin.
    """

    model: StrictStr

    response_instruction: Optional[StrictStr] = None

    experimental: Optional[Dict[str, Any]] = None

    messages: Annotated[List[Message], Field(min_length=1)]

    tools: Optional[List[Tool]] = None

    tool_resources: Optional[Dict[str, Dict[str, Any]]] = None

    tool_choice: Optional[ToolChoice] = None

    thread_id: Optional[StrictInt] = None

    parent_message_id: Optional[StrictInt] = None

    __properties = [
        "model", "response_instruction", "experimental", "messages", "tools",
        "tool_resources", "tool_choice", "thread_id", "parent_message_id"
    ]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AgentRunRequest:
        """Create an instance of AgentRunRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in messages (list)
        _items = []
        if self.messages:
            for _item in self.messages:
                if _item:
                    _items.append(_item.to_dict())
            _dict['messages'] = _items

        # override the default output from pydantic by calling `to_dict()` of each item in tools (list)
        _items = []
        if self.tools:
            for _item in self.tools:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tools'] = _items

        # override the default output from pydantic by calling `to_dict()` of tool_choice
        if self.tool_choice:
            _dict['tool_choice'] = self.tool_choice.to_dict()

        # set to None if tool_choice (nullable) is None
        if self.tool_choice is None:
            _dict['tool_choice'] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> AgentRunRequest:
        """Create an instance of AgentRunRequest from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return AgentRunRequest.parse_obj(obj)

        _obj = AgentRunRequest.parse_obj({
            "model":
            obj.get("model"),
            "response_instruction":
            obj.get("response_instruction"),
            "experimental":
            obj.get("experimental"),
            "messages":
            [Message.from_dict(_item) for _item in obj.get("messages")]
            if obj.get("messages") is not None else None,
            "tools": [Tool.from_dict(_item) for _item in obj.get("tools")]
            if obj.get("tools") is not None else None,
            "tool_resources":
            obj.get("tool_resources"),
            "tool_choice":
            ToolChoice.from_dict(obj.get("tool_choice"))
            if obj.get("tool_choice") is not None else None,
            "thread_id":
            obj.get("thread_id"),
            "parent_message_id":
            obj.get("parent_message_id"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.cortex.lite_agent_service._generated.models.message import Message

from snowflake.core.cortex.lite_agent_service._generated.models.tool import Tool

from snowflake.core.cortex.lite_agent_service._generated.models.tool_choice import ToolChoice


class AgentRunRequestModel():

    def __init__(
        self,
        model: str,
        messages: List[Message],
        # optional properties
        response_instruction: Optional[str] = None,
        experimental: Optional[object] = None,
        tools: Optional[List[Tool]] = None,
        tool_resources: Optional[Dict[str, object]] = None,
        tool_choice: Optional[ToolChoice] = None,
        thread_id: Optional[int] = None,
        parent_message_id: Optional[int] = None,
    ):
        """A model object representing the AgentRunRequest resource.

        Constructs an object of type AgentRunRequest with the provided properties.

        Parameters
        __________
        model : str
            The identifier of the LLM to use for processing.
        messages : List[Message]
            The conversation history and current message.
Contains both user queries and assistant responses in chronological order.

        response_instruction : str, optional
            Optional instructions to guide the model's response style and behavior.
Can be used to set the tone, format, or specific requirements for responses.

        experimental : object, optional
            reserved
        tools : List[Tool], optional
            List of tools available for the agent to use.
Tools may have a corresponding configuration in tool_resources.

        tool_resources : Dict[str, object], optional
            Configuration for each tool referenced in the tools array.
Keys must match the name field of tools.

        tool_choice : ToolChoice, optional

        thread_id : int, optional
            The id of the thread.

        parent_message_id : int, optional
            The id of the message from which this run should begin.
        """

        self.model = model
        self.response_instruction = response_instruction
        self.experimental = experimental
        self.messages = messages
        self.tools = tools
        self.tool_resources = tool_resources
        self.tool_choice = tool_choice
        self.thread_id = thread_id
        self.parent_message_id = parent_message_id

    __properties = [
        "model", "response_instruction", "experimental", "messages", "tools",
        "tool_resources", "tool_choice", "thread_id", "parent_message_id"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return AgentRunRequest(
            model=self.model,
            response_instruction=self.response_instruction,
            experimental=self.experimental,
            messages=[x._to_model() for x in self.messages]
            if self.messages is not None else None,
            tools=[x._to_model()
                   for x in self.tools] if self.tools is not None else None,
            tool_resources=self.tool_resources,
            tool_choice=self.tool_choice._to_model()
            if self.tool_choice is not None else None,
            thread_id=self.thread_id,
            parent_message_id=self.parent_message_id,
        )

    @classmethod
    def _from_model(cls, model) -> AgentRunRequestModel:
        return AgentRunRequestModel(
            model=model.model,
            response_instruction=model.response_instruction,
            experimental=model.experimental,
            messages=[MessageModel._from_model(x) for x in model.messages]
            if model.messages is not None else None,
            tools=[ToolModel._from_model(x)
                   for x in model.tools] if model.tools is not None else None,
            tool_resources=model.tool_resources,
            tool_choice=ToolChoiceModel._from_model(model.tool_choice)
            if model.tool_choice is not None else None,
            thread_id=model.thread_id,
            parent_message_id=model.parent_message_id,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a AgentRunRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the AgentRunRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AgentRunRequestModel:
        """Creates an instance of AgentRunRequest from a dict.

        This method constructs a AgentRunRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        AgentRunRequest
            A AgentRunRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(AgentRunRequest.from_dict(obj))


AgentRunRequest._model_class = AgentRunRequestModel
