# coding: utf-8
"""
    Cortex Agent API.

    OpenAPI 3.0 specification for the Cortex Agent API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class AnalystResource(BaseModel):
    """A model object representing the AnalystResource resource.

    Constructs an object of type AnalystResource with the provided properties.

    Parameters
    __________
    semantic_model_file : str, optional
        The path to a file stored in a Snowflake Stage holding the semantic model yaml.
    semantic_view : str, optional
        The name of the Snowflake native semantic model object
    """

    semantic_model_file: Optional[StrictStr] = None

    semantic_view: Optional[StrictStr] = None

    additional_properties: dict[str, Any] = {}

    __properties = ["semantic_model_file", "semantic_view"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AnalystResource:
        """Create an instance of AnalystResource from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = {"additional_properties"}

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> AnalystResource:
        """Create an instance of AnalystResource from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return AnalystResource.parse_obj(obj)

        _obj = AnalystResource.parse_obj({
            "semantic_model_file":
            obj.get("semantic_model_file"),
            "semantic_view":
            obj.get("semantic_view"),
        })

        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


from typing import Optional, List, Dict


class AnalystResourceModel():

    def __init__(
        self,  # optional properties
        semantic_model_file: Optional[str] = None,
        semantic_view: Optional[str] = None,
    ):
        """A model object representing the AnalystResource resource.

        Constructs an object of type AnalystResource with the provided properties.

        Parameters
        __________
        semantic_model_file : str, optional
            The path to a file stored in a Snowflake Stage holding the semantic model yaml.

        semantic_view : str, optional
            The name of the Snowflake native semantic model object
        """

        self.semantic_model_file = semantic_model_file
        self.semantic_view = semantic_view

    additional_properties: dict[str, Any] = {}

    __properties = ["semantic_model_file", "semantic_view"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return AnalystResource(
            semantic_model_file=self.semantic_model_file,
            semantic_view=self.semantic_view,
        )

    @classmethod
    def _from_model(cls, model) -> AnalystResourceModel:
        return AnalystResourceModel(
            semantic_model_file=model.semantic_model_file,
            semantic_view=model.semantic_view,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a AnalystResource.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the AnalystResource object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AnalystResourceModel:
        """Creates an instance of AnalystResource from a dict.

        This method constructs a AnalystResource object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        AnalystResource
            A AnalystResource object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(AnalystResource.from_dict(obj))


AnalystResource._model_class = AnalystResourceModel
