# coding: utf-8
"""
    Cortex Agent API.

    OpenAPI 3.0 specification for the Cortex Agent API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictStr, field_validator

from typing import Any, ClassVar, Dict, List


class TextContent(BaseModel):
    """A model object representing the TextContent resource.

    Constructs an object of type TextContent with the provided properties.

    Parameters
    __________
    type : str
        Identifies this as text content.
    text : str
        The actual text content of the message.
    """

    type: StrictStr

    text: StrictStr

    __properties = ["type", "text"]

    @field_validator('type')
    def type_validate_enum(cls, v):

        if v not in ('text'):
            raise ValueError("must validate the enum values ('text')")
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TextContent:
        """Create an instance of TextContent from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> TextContent:
        """Create an instance of TextContent from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return TextContent.parse_obj(obj)

        _obj = TextContent.parse_obj({
            "type": obj.get("type"),
            "text": obj.get("text"),
        })

        return _obj


from typing import Optional, List, Dict


class TextContentModel():

    def __init__(
        self,
        type: str,
        text: str,
        # optional properties
    ):
        """A model object representing the TextContent resource.

        Constructs an object of type TextContent with the provided properties.

        Parameters
        __________
        type : str
            Identifies this as text content.
        text : str
            The actual text content of the message.
        """

        self.type = type
        self.text = text

    __properties = ["type", "text"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return TextContent(
            type=self.type,
            text=self.text,
        )

    @classmethod
    def _from_model(cls, model) -> TextContentModel:
        return TextContentModel(
            type=model.type,
            text=model.text,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a TextContent.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the TextContent object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> TextContentModel:
        """Creates an instance of TextContent from a dict.

        This method constructs a TextContent object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        TextContent
            A TextContent object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(TextContent.from_dict(obj))


TextContent._model_class = TextContentModel
