# coding: utf-8
"""
    Cortex Search REST API.

    OpenAPI 3.0 specification for the Cortex Search REST API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.cortex.search_service._generated.models.scoring_config import ScoringConfig

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class QueryRequest(BaseModel):
    """A model object representing the QueryRequest resource.

    Constructs an object of type QueryRequest with the provided properties.

    Parameters
    __________
    query : str, optional
        Unstructured text query.  Exactly one of 'query' or 'multi_index_query' must be specified.
    multi_index_query : object, optional
        A search query expressed as a collection of multiple column-level queries.  Exactly one of 'query' or 'multi_index_query' must be specified. A column/index can be queried with multiple queries.
    columns : List[str], optional
        List of columns to return.
    filter : object, optional
        Filter query.
    limit : int,  default 10
        Max number of results to return.
    scoring_config : ScoringConfig, optional

    scoring_profile : str, optional
        Mutually exclusive with scoring_config. Specifies the pre-defined name of a profile on the cortex search service that resolves to scoring_config.
    experimental : object, optional
        reserved
    """

    query: Optional[StrictStr] = None

    multi_index_query: Optional[Dict[str, Any]] = None

    columns: Optional[List[StrictStr]] = None

    filter: Optional[Dict[str, Any]] = None

    limit: Optional[StrictInt] = 10

    scoring_config: Optional[ScoringConfig] = None

    scoring_profile: Optional[StrictStr] = None

    experimental: Optional[Dict[str, Any]] = None

    __properties = [
        "query", "multi_index_query", "columns", "filter", "limit",
        "scoring_config", "scoring_profile", "experimental"
    ]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> QueryRequest:
        """Create an instance of QueryRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of scoring_config
        if self.scoring_config:
            _dict['scoring_config'] = self.scoring_config.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> QueryRequest:
        """Create an instance of QueryRequest from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return QueryRequest.parse_obj(obj)

        _obj = QueryRequest.parse_obj({
            "query":
            obj.get("query"),
            "multi_index_query":
            obj.get("multi_index_query"),
            "columns":
            obj.get("columns"),
            "filter":
            obj.get("filter"),
            "limit":
            obj.get("limit") if obj.get("limit") is not None else 10,
            "scoring_config":
            ScoringConfig.from_dict(obj.get("scoring_config"))
            if obj.get("scoring_config") is not None else None,
            "scoring_profile":
            obj.get("scoring_profile"),
            "experimental":
            obj.get("experimental"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.cortex.search_service._generated.models.scoring_config import ScoringConfig


class QueryRequestModel():

    def __init__(
        self,  # optional properties
        query: Optional[str] = None,
        multi_index_query: Optional[object] = None,
        columns: Optional[List[str]] = None,
        filter: Optional[object] = None,
        limit: Optional[int] = 10,
        scoring_config: Optional[ScoringConfig] = None,
        scoring_profile: Optional[str] = None,
        experimental: Optional[object] = None,
    ):
        """A model object representing the QueryRequest resource.

        Constructs an object of type QueryRequest with the provided properties.

        Parameters
        __________
        query : str, optional
            Unstructured text query.  Exactly one of 'query' or 'multi_index_query' must be specified.
        multi_index_query : object, optional
            A search query expressed as a collection of multiple column-level queries.  Exactly one of 'query' or 'multi_index_query' must be specified. A column/index can be queried with multiple queries.
        columns : List[str], optional
            List of columns to return.
        filter : object, optional
            Filter query.
        limit : int,  default 10
            Max number of results to return.
        scoring_config : ScoringConfig, optional

        scoring_profile : str, optional
            Mutually exclusive with scoring_config. Specifies the pre-defined name of a profile on the cortex search service that resolves to scoring_config.
        experimental : object, optional
            reserved
        """

        self.query = query
        self.multi_index_query = multi_index_query
        self.columns = columns
        self.filter = filter
        self.limit = limit
        self.scoring_config = scoring_config
        self.scoring_profile = scoring_profile
        self.experimental = experimental

    __properties = [
        "query", "multi_index_query", "columns", "filter", "limit",
        "scoring_config", "scoring_profile", "experimental"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return QueryRequest(
            query=self.query,
            multi_index_query=self.multi_index_query,
            columns=self.columns,
            filter=self.filter,
            limit=self.limit,
            scoring_config=self.scoring_config._to_model()
            if self.scoring_config is not None else None,
            scoring_profile=self.scoring_profile,
            experimental=self.experimental,
        )

    @classmethod
    def _from_model(cls, model) -> QueryRequestModel:
        return QueryRequestModel(
            query=model.query,
            multi_index_query=model.multi_index_query,
            columns=model.columns,
            filter=model.filter,
            limit=model.limit,
            scoring_config=ScoringConfigModel._from_model(model.scoring_config)
            if model.scoring_config is not None else None,
            scoring_profile=model.scoring_profile,
            experimental=model.experimental,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a QueryRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the QueryRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> QueryRequestModel:
        """Creates an instance of QueryRequest from a dict.

        This method constructs a QueryRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        QueryRequest
            A QueryRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(QueryRequest.from_dict(obj))


QueryRequest._model_class = QueryRequestModel
