# coding: utf-8
"""
    Cortex Search REST API.

    OpenAPI 3.0 specification for the Cortex Search REST API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List


class QueryResponse(BaseModel):
    """A model object representing the QueryResponse resource.

    Constructs an object of type QueryResponse with the provided properties.

    Parameters
    __________
    results : List[Dict[str, object]]
        List of result rows.
    request_id : str
        ID of the request.
    """

    results: List[Dict[str, Any]]

    request_id: StrictStr

    __properties = ["results", "request_id"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> QueryResponse:
        """Create an instance of QueryResponse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> QueryResponse:
        """Create an instance of QueryResponse from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return QueryResponse.parse_obj(obj)

        _obj = QueryResponse.parse_obj({
            "results": obj.get("results"),
            "request_id": obj.get("request_id"),
        })

        return _obj


from typing import Optional, List, Dict


class QueryResponseModel():

    def __init__(
        self,
        results: List[Dict[str, object]],
        request_id: str,
        # optional properties
    ):
        """A model object representing the QueryResponse resource.

        Constructs an object of type QueryResponse with the provided properties.

        Parameters
        __________
        results : List[Dict[str, object]]
            List of result rows.
        request_id : str
            ID of the request.
        """

        self.results = results
        self.request_id = request_id

    __properties = ["results", "request_id"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return QueryResponse(
            results=self.results,
            request_id=self.request_id,
        )

    @classmethod
    def _from_model(cls, model) -> QueryResponseModel:
        return QueryResponseModel(
            results=model.results,
            request_id=model.request_id,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a QueryResponse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the QueryResponse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> QueryResponseModel:
        """Creates an instance of QueryResponse from a dict.

        This method constructs a QueryResponse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        QueryResponse
            A QueryResponse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(QueryResponse.from_dict(obj))


QueryResponse._model_class = QueryResponseModel
