# coding: utf-8
"""
    Cortex Search REST API.

    OpenAPI 3.0 specification for the Cortex Search REST API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class QuerySimilarityBoost(BaseModel):
    """A model object representing the QuerySimilarityBoost resource.

    Constructs an object of type QuerySimilarityBoost with the provided properties.

    Parameters
    __________
    cortex_search_service : str, optional
        Fully-qualified name of a Cortex Search Service through which to find similar previous queries.
    previous_query_column : str, optional
        Name of a TEXT column indexed in the specified previous queries search service that contains the previous query strings.
    documents_column : str, optional
        Name of an ARRAY column indexed in the specified previous queries search service that contains a list of documents that matched the corresponding previous query. Each document is represented as an OBJECT mapping all primary key columns to their corresponding values.
    """

    cortex_search_service: Optional[StrictStr] = None

    previous_query_column: Optional[StrictStr] = None

    documents_column: Optional[StrictStr] = None

    __properties = [
        "cortex_search_service", "previous_query_column", "documents_column"
    ]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> QuerySimilarityBoost:
        """Create an instance of QuerySimilarityBoost from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> QuerySimilarityBoost:
        """Create an instance of QuerySimilarityBoost from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return QuerySimilarityBoost.parse_obj(obj)

        _obj = QuerySimilarityBoost.parse_obj({
            "cortex_search_service":
            obj.get("cortex_search_service"),
            "previous_query_column":
            obj.get("previous_query_column"),
            "documents_column":
            obj.get("documents_column"),
        })

        return _obj


from typing import Optional, List, Dict


class QuerySimilarityBoostModel():

    def __init__(
        self,  # optional properties
        cortex_search_service: Optional[str] = None,
        previous_query_column: Optional[str] = None,
        documents_column: Optional[str] = None,
    ):
        """A model object representing the QuerySimilarityBoost resource.

        Constructs an object of type QuerySimilarityBoost with the provided properties.

        Parameters
        __________
        cortex_search_service : str, optional
            Fully-qualified name of a Cortex Search Service through which to find similar previous queries.
        previous_query_column : str, optional
            Name of a TEXT column indexed in the specified previous queries search service that contains the previous query strings.
        documents_column : str, optional
            Name of an ARRAY column indexed in the specified previous queries search service that contains a list of documents that matched the corresponding previous query. Each document is represented as an OBJECT mapping all primary key columns to their corresponding values.
        """

        self.cortex_search_service = cortex_search_service
        self.previous_query_column = previous_query_column
        self.documents_column = documents_column

    __properties = [
        "cortex_search_service", "previous_query_column", "documents_column"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return QuerySimilarityBoost(
            cortex_search_service=self.cortex_search_service,
            previous_query_column=self.previous_query_column,
            documents_column=self.documents_column,
        )

    @classmethod
    def _from_model(cls, model) -> QuerySimilarityBoostModel:
        return QuerySimilarityBoostModel(
            cortex_search_service=model.cortex_search_service,
            previous_query_column=model.previous_query_column,
            documents_column=model.documents_column,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a QuerySimilarityBoost.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the QuerySimilarityBoost object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> QuerySimilarityBoostModel:
        """Creates an instance of QuerySimilarityBoost from a dict.

        This method constructs a QuerySimilarityBoost object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        QuerySimilarityBoost
            A QuerySimilarityBoost object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(QuerySimilarityBoost.from_dict(obj))


QuerySimilarityBoost._model_class = QuerySimilarityBoostModel
