# coding: utf-8
"""
    Cortex Search REST API.

    OpenAPI 3.0 specification for the Cortex Search REST API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict

from typing import Any, ClassVar, Dict, List, Optional


class ResultRow(BaseModel):
    """A model object representing the ResultRow resource.

    Constructs an object of type ResultRow with the provided properties.

    Parameters
    __________
    columns : object, optional
    """

    columns: Optional[Dict[str, Any]] = None

    __properties = ["columns"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ResultRow:
        """Create an instance of ResultRow from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ResultRow:
        """Create an instance of ResultRow from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return ResultRow.parse_obj(obj)

        _obj = ResultRow.parse_obj({
            "columns": obj.get("columns"),
        })

        return _obj


from typing import Optional, List, Dict


class ResultRowModel():

    def __init__(
        self,  # optional properties
        columns: Optional[object] = None,
    ):
        """A model object representing the ResultRow resource.

        Constructs an object of type ResultRow with the provided properties.

        Parameters
        __________
        columns : object, optional
        """

        self.columns = columns

    __properties = ["columns"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ResultRow(columns=self.columns, )

    @classmethod
    def _from_model(cls, model) -> ResultRowModel:
        return ResultRowModel(columns=model.columns, )

    def to_dict(self):
        """Creates a dictionary of the properties from a ResultRow.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ResultRow object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ResultRowModel:
        """Creates an instance of ResultRow from a dict.

        This method constructs a ResultRow object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ResultRow
            A ResultRow object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ResultRow.from_dict(obj))


ResultRow._model_class = ResultRowModel
