# coding: utf-8
"""
    Cortex Search REST API.

    OpenAPI 3.0 specification for the Cortex Search REST API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class SendFeedbackRequest(BaseModel):
    """A model object representing the SendFeedbackRequest resource.

    Constructs an object of type SendFeedbackRequest with the provided properties.

    Parameters
    __________
    request_id : str
        Request id associated with the feedback
    positive : bool
        Whether the results were good (true) or bad (false)
    feedback_message : str, optional
        The text for the detailed feedback message
    """

    request_id: StrictStr

    positive: StrictBool

    feedback_message: Optional[StrictStr] = None

    __properties = ["request_id", "positive", "feedback_message"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SendFeedbackRequest:
        """Create an instance of SendFeedbackRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> SendFeedbackRequest:
        """Create an instance of SendFeedbackRequest from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return SendFeedbackRequest.parse_obj(obj)

        _obj = SendFeedbackRequest.parse_obj({
            "request_id":
            obj.get("request_id"),
            "positive":
            obj.get("positive"),
            "feedback_message":
            obj.get("feedback_message"),
        })

        return _obj


from typing import Optional, List, Dict


class SendFeedbackRequestModel():

    def __init__(
        self,
        request_id: str,
        positive: bool,
        # optional properties
        feedback_message: Optional[str] = None,
    ):
        """A model object representing the SendFeedbackRequest resource.

        Constructs an object of type SendFeedbackRequest with the provided properties.

        Parameters
        __________
        request_id : str
            Request id associated with the feedback
        positive : bool
            Whether the results were good (true) or bad (false)
        feedback_message : str, optional
            The text for the detailed feedback message
        """

        self.request_id = request_id
        self.positive = positive
        self.feedback_message = feedback_message

    __properties = ["request_id", "positive", "feedback_message"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return SendFeedbackRequest(
            request_id=self.request_id,
            positive=self.positive,
            feedback_message=self.feedback_message,
        )

    @classmethod
    def _from_model(cls, model) -> SendFeedbackRequestModel:
        return SendFeedbackRequestModel(
            request_id=model.request_id,
            positive=model.positive,
            feedback_message=model.feedback_message,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a SendFeedbackRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the SendFeedbackRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> SendFeedbackRequestModel:
        """Creates an instance of SendFeedbackRequest from a dict.

        This method constructs a SendFeedbackRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        SendFeedbackRequest
            A SendFeedbackRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(SendFeedbackRequest.from_dict(obj))


SendFeedbackRequest._model_class = SendFeedbackRequestModel
