# coding: utf-8
"""
    Cortex Search REST API.

    OpenAPI 3.0 specification for the Cortex Search REST API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.cortex.search_service._generated.models.result_row import ResultRow

from pydantic import BaseModel, ConfigDict

from typing import Any, ClassVar, Dict, List, Optional


class SuggestResult(BaseModel):
    """A model object representing the SuggestResult resource.

    Constructs an object of type SuggestResult with the provided properties.

    Parameters
    __________
    rows : List[ResultRow], optional
        List of result rows.
    """

    rows: Optional[List[ResultRow]] = None

    __properties = ["rows"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SuggestResult:
        """Create an instance of SuggestResult from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in rows (list)
        _items = []
        if self.rows:
            for _item in self.rows:
                if _item:
                    _items.append(_item.to_dict())
            _dict['rows'] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> SuggestResult:
        """Create an instance of SuggestResult from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return SuggestResult.parse_obj(obj)

        _obj = SuggestResult.parse_obj({
            "rows": [ResultRow.from_dict(_item) for _item in obj.get("rows")]
            if obj.get("rows") is not None else None,
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.cortex.search_service._generated.models.result_row import ResultRow


class SuggestResultModel():

    def __init__(
        self,  # optional properties
        rows: Optional[List[ResultRow]] = None,
    ):
        """A model object representing the SuggestResult resource.

        Constructs an object of type SuggestResult with the provided properties.

        Parameters
        __________
        rows : List[ResultRow], optional
            List of result rows.
        """

        self.rows = rows

    __properties = ["rows"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return SuggestResult(
            rows=[x._to_model()
                  for x in self.rows] if self.rows is not None else None, )

    @classmethod
    def _from_model(cls, model) -> SuggestResultModel:
        return SuggestResultModel(
            rows=[ResultRowModel._from_model(x)
                  for x in model.rows] if model.rows is not None else None, )

    def to_dict(self):
        """Creates a dictionary of the properties from a SuggestResult.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the SuggestResult object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> SuggestResultModel:
        """Creates an instance of SuggestResult from a dict.

        This method constructs a SuggestResult object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        SuggestResult
            A SuggestResult object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(SuggestResult.from_dict(obj))


SuggestResult._model_class = SuggestResultModel
