# coding: utf-8
"""
    Cortex Analyst API.

    The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import absolute_import

import logging
from pydantic import StrictStr
from snowflake.core.cortex_analyst._generated.models.fast_generation_request import FastGenerationRequest
from snowflake.core.cortex_analyst._generated.models.generate_verified_query_suggestions_request import GenerateVerifiedQuerySuggestionsRequest
from snowflake.core.cortex_analyst._generated.models.generate_verified_query_suggestions_response import GenerateVerifiedQuerySuggestionsResponse
from snowflake.core.cortex_analyst._generated.models.pre_selection_request import PreSelectionRequest
from snowflake.core.cortex_analyst._generated.models.pre_selection_response import PreSelectionResponse
from snowflake.core.cortex_analyst._generated.models.send_feedback_request import SendFeedbackRequest
from snowflake.core.cortex_analyst._generated.models.send_message_request import SendMessageRequest
from snowflake.core.cortex_analyst._generated.models.send_message_response import SendMessageResponse
from snowflake.core.cortex_analyst._generated.models.success_response import SuccessResponse
from snowflake.core.cortex_analyst._generated.models.token_info import TokenInfo
from typing import Iterable

from snowflake.core.cortex_analyst._generated.api_client import ApiClient

from concurrent.futures import Future
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Literal, Optional, Tuple, Union, overload
from typing_extensions import Annotated

from snowflake.core._internal.utils import is_running_inside_stored_procedure

from snowflake.core.exceptions import (  # noqa: F401
    _APITypeError, _APIValueError)

logger = logging.getLogger(__name__)


class CortexAnalystApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech.

    Do not edit the class manually.
    """

    def __init__(self, root, resource_class, sproc_client):
        self._root = root
        self._resource_name = 'cortex_analyst'
        self._resource_class = resource_class

        if is_running_inside_stored_procedure():
            self._api_client = sproc_client
        else:
            self._api_client = ApiClient.get_default(self._root)

    @property
    def api_client(self):
        return self._api_client

    @overload
    def fast_generation(self,
                        fast_generation_request: FastGenerationRequest,
                        async_req: Literal[False] = False,
                        **kwargs) -> str:
        ...

    @overload
    def fast_generation(self,
                        fast_generation_request: FastGenerationRequest,
                        async_req: Literal[True] = True,
                        **kwargs) -> Future[str]:
        ...

    @overload
    def fast_generation(self,
                        fast_generation_request: FastGenerationRequest,
                        async_req: bool = False,
                        **kwargs) -> Union[str, Future[str]]:
        ...

    @validate_call
    def fast_generation(self, fast_generation_request: FastGenerationRequest,
                        **kwargs) -> Union[str, Future[str]]:  # noqa: E501
        """Rapidly generate a semantic model given source material  # noqa: E501.

        Provides real-time suggestions for improving a given semantic model via a streaming response.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fast_generation(fast_generation_request, async_req=True)
        >>> result = future.result()
        :param fast_generation_request: (required)
        :type fast_generation_request: FastGenerationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[str, Future[str]]
        """
        kwargs['_return_http_data_only'] = True
        return self.fast_generation_with_http_info(fast_generation_request,
                                                   **kwargs)  # noqa: E501

    @validate_call
    def fast_generation_with_http_info(
            self, fast_generation_request: FastGenerationRequest,
            **kwargs):  # noqa: E501
        """Rapidly generate a semantic model given source material  # noqa: E501.

        Provides real-time suggestions for improving a given semantic model via a streaming response.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fast_generation_with_http_info(fast_generation_request, async_req=True)
        >>> result = future.result()
        :param fast_generation_request: (required)
        :type fast_generation_request: FastGenerationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[str, Future[str]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['fast_generation_request']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method fast_generation" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['fast_generation_request']:
            _body_params = _params['fast_generation_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/event-stream', 'application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/cortex/analyst/fast-generation',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def generate_verified_query_suggestions(
            self,
            generate_verified_query_suggestions_request:
        GenerateVerifiedQuerySuggestionsRequest,
            async_req: Literal[False] = False,
            **kwargs) -> GenerateVerifiedQuerySuggestionsResponse:
        ...

    @overload
    def generate_verified_query_suggestions(
            self,
            generate_verified_query_suggestions_request:
        GenerateVerifiedQuerySuggestionsRequest,
            async_req: Literal[True] = True,
            **kwargs) -> Future[GenerateVerifiedQuerySuggestionsResponse]:
        ...

    @overload
    def generate_verified_query_suggestions(
        self,
        generate_verified_query_suggestions_request:
        GenerateVerifiedQuerySuggestionsRequest,
        async_req: bool = False,
        **kwargs
    ) -> Union[GenerateVerifiedQuerySuggestionsResponse,
               Future[GenerateVerifiedQuerySuggestionsResponse]]:
        ...

    @validate_call
    def generate_verified_query_suggestions(
        self, generate_verified_query_suggestions_request:
        GenerateVerifiedQuerySuggestionsRequest, **kwargs
    ) -> Union[GenerateVerifiedQuerySuggestionsResponse,
               Future[GenerateVerifiedQuerySuggestionsResponse]]:  # noqa: E501
        """Generate VQ suggestions for a semantic model  # noqa: E501.

        Generate VQ suggestions for a semantic model  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.generate_verified_query_suggestions(generate_verified_query_suggestions_request, async_req=True)
        >>> result = future.result()
        :param generate_verified_query_suggestions_request: (required)
        :type generate_verified_query_suggestions_request: GenerateVerifiedQuerySuggestionsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[GenerateVerifiedQuerySuggestionsResponse, Future[GenerateVerifiedQuerySuggestionsResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.generate_verified_query_suggestions_with_http_info(
            generate_verified_query_suggestions_request,
            **kwargs)  # noqa: E501

    @validate_call
    def generate_verified_query_suggestions_with_http_info(
            self, generate_verified_query_suggestions_request:
        GenerateVerifiedQuerySuggestionsRequest, **kwargs):  # noqa: E501
        """Generate VQ suggestions for a semantic model  # noqa: E501.

        Generate VQ suggestions for a semantic model  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.generate_verified_query_suggestions_with_http_info(generate_verified_query_suggestions_request, async_req=True)
        >>> result = future.result()
        :param generate_verified_query_suggestions_request: (required)
        :type generate_verified_query_suggestions_request: GenerateVerifiedQuerySuggestionsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[GenerateVerifiedQuerySuggestionsResponse, Future[GenerateVerifiedQuerySuggestionsResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['generate_verified_query_suggestions_request']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_verified_query_suggestions" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['generate_verified_query_suggestions_request']:
            _body_params = _params[
                'generate_verified_query_suggestions_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "GenerateVerifiedQuerySuggestionsResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/cortex/analyst/verified-query-suggestions',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def get_scoped_token(self,
                         async_req: Literal[False] = False,
                         **kwargs) -> TokenInfo:
        ...

    @overload
    def get_scoped_token(self,
                         async_req: Literal[True] = True,
                         **kwargs) -> Future[TokenInfo]:
        ...

    @overload
    def get_scoped_token(self,
                         async_req: bool = False,
                         **kwargs) -> Union[TokenInfo, Future[TokenInfo]]:
        ...

    @validate_call
    def get_scoped_token(
            self,
            **kwargs) -> Union[TokenInfo, Future[TokenInfo]]:  # noqa: E501
        """Internal endpoint to exchange a Cortex Analyst Oauth token  # noqa: E501.

        Internal endpoint to exchange a Cortex Analyst Oauth token  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_scoped_token(async_req=True)
        >>> result = future.result()
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[TokenInfo, Future[TokenInfo]]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_scoped_token_with_http_info(**kwargs)  # noqa: E501

    @validate_call
    def get_scoped_token_with_http_info(self, **kwargs):  # noqa: E501
        """Internal endpoint to exchange a Cortex Analyst Oauth token  # noqa: E501.

        Internal endpoint to exchange a Cortex Analyst Oauth token  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.get_scoped_token_with_http_info(async_req=True)
        >>> result = future.result()
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[TokenInfo, Future[TokenInfo]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method get_scoped_token" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "TokenInfo",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/cortex/analyst/token',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def pre_selection(self,
                      pre_selection_request: PreSelectionRequest,
                      async_req: Literal[False] = False,
                      **kwargs) -> PreSelectionResponse:
        ...

    @overload
    def pre_selection(self,
                      pre_selection_request: PreSelectionRequest,
                      async_req: Literal[True] = True,
                      **kwargs) -> Future[PreSelectionResponse]:
        ...

    @overload
    def pre_selection(
            self,
            pre_selection_request: PreSelectionRequest,
            async_req: bool = False,
            **kwargs
    ) -> Union[PreSelectionResponse, Future[PreSelectionResponse]]:
        ...

    @validate_call
    def pre_selection(
        self, pre_selection_request: PreSelectionRequest, **kwargs
    ) -> Union[PreSelectionResponse,
               Future[PreSelectionResponse]]:  # noqa: E501
        """Retrieve relevant table information from input data for semantic model generation  # noqa: E501.

        Retrieve relevant table information from input data for semantic model generation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.pre_selection(pre_selection_request, async_req=True)
        >>> result = future.result()
        :param pre_selection_request: (required)
        :type pre_selection_request: PreSelectionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[PreSelectionResponse, Future[PreSelectionResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.pre_selection_with_http_info(pre_selection_request,
                                                 **kwargs)  # noqa: E501

    @validate_call
    def pre_selection_with_http_info(
            self, pre_selection_request: PreSelectionRequest,
            **kwargs):  # noqa: E501
        """Retrieve relevant table information from input data for semantic model generation  # noqa: E501.

        Retrieve relevant table information from input data for semantic model generation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.pre_selection_with_http_info(pre_selection_request, async_req=True)
        >>> result = future.result()
        :param pre_selection_request: (required)
        :type pre_selection_request: PreSelectionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[PreSelectionResponse, Future[PreSelectionResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['pre_selection_request']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method pre_selection" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['pre_selection_request']:
            _body_params = _params['pre_selection_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "PreSelectionResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/cortex/analyst/pre-selection',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def send_feedback(self,
                      send_feedback_request: SendFeedbackRequest,
                      async_req: Literal[False] = False,
                      **kwargs) -> SuccessResponse:
        ...

    @overload
    def send_feedback(self,
                      send_feedback_request: SendFeedbackRequest,
                      async_req: Literal[True] = True,
                      **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def send_feedback(
            self,
            send_feedback_request: SendFeedbackRequest,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def send_feedback(
        self, send_feedback_request: SendFeedbackRequest, **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Send_feedback  # noqa: E501.

        Send a user feedback of Cortex Analyst response  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.send_feedback(send_feedback_request, async_req=True)
        >>> result = future.result()
        :param send_feedback_request: (required)
        :type send_feedback_request: SendFeedbackRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.send_feedback_with_http_info(send_feedback_request,
                                                 **kwargs)  # noqa: E501

    @validate_call
    def send_feedback_with_http_info(
            self, send_feedback_request: SendFeedbackRequest,
            **kwargs):  # noqa: E501
        """Send_feedback  # noqa: E501.

        Send a user feedback of Cortex Analyst response  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.send_feedback_with_http_info(send_feedback_request, async_req=True)
        >>> result = future.result()
        :param send_feedback_request: (required)
        :type send_feedback_request: SendFeedbackRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['send_feedback_request']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method send_feedback" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['send_feedback_request']:
            _body_params = _params['send_feedback_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/cortex/analyst/feedback',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def send_message(self,
                     send_message_request: SendMessageRequest,
                     async_req: Literal[False] = False,
                     **kwargs) -> SendMessageResponse:
        ...

    @overload
    def send_message(self,
                     send_message_request: SendMessageRequest,
                     async_req: Literal[True] = True,
                     **kwargs) -> Future[SendMessageResponse]:
        ...

    @overload
    def send_message(
            self,
            send_message_request: SendMessageRequest,
            async_req: bool = False,
            **kwargs
    ) -> Union[SendMessageResponse, Future[SendMessageResponse]]:
        ...

    @validate_call
    def send_message(
        self, send_message_request: SendMessageRequest, **kwargs
    ) -> Union[SendMessageResponse, Future[SendMessageResponse]]:  # noqa: E501
        """Send a data question to the Cortex Analyst  # noqa: E501.

        Send a data question to the Cortex Analyst  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.send_message(send_message_request, async_req=True)
        >>> result = future.result()
        :param send_message_request: (required)
        :type send_message_request: SendMessageRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SendMessageResponse, Future[SendMessageResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.send_message_with_http_info(send_message_request,
                                                **kwargs)  # noqa: E501

    @validate_call
    def send_message_with_http_info(self,
                                    send_message_request: SendMessageRequest,
                                    **kwargs):  # noqa: E501
        """Send a data question to the Cortex Analyst  # noqa: E501.

        Send a data question to the Cortex Analyst  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.send_message_with_http_info(send_message_request, async_req=True)
        >>> result = future.result()
        :param send_message_request: (required)
        :type send_message_request: SendMessageRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SendMessageResponse, Future[SendMessageResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['send_message_request']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method send_message" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['send_message_request']:
            _body_params = _params['send_message_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/event-stream'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SendMessageResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/cortex/analyst/message',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
