# coding: utf-8
"""
    Cortex Analyst API.

    The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, Field, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class AnnotatedSqlQuery(BaseModel):
    """A model object representing the AnnotatedSqlQuery resource.

    Constructs an object of type AnnotatedSqlQuery with the provided properties.

    Parameters
    __________
    sql_text : str
        SQL query text
    database : str, optional
        Database associated with the SQL query
    var_schema : str, optional
        Schema associated with the SQL query
    corresponding_question : str, optional
        Natural language question that the SQL query answers
    additional_context : str, optional
        Free-form string for additional context about the query
    """

    sql_text: StrictStr

    database: Optional[StrictStr] = None

    var_schema: Optional[StrictStr] = Field(default=None, alias="schema")

    corresponding_question: Optional[StrictStr] = None

    additional_context: Optional[StrictStr] = None

    __properties = [
        "sql_text", "database", "schema", "corresponding_question",
        "additional_context"
    ]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AnnotatedSqlQuery:
        """Create an instance of AnnotatedSqlQuery from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> AnnotatedSqlQuery:
        """Create an instance of AnnotatedSqlQuery from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return AnnotatedSqlQuery.parse_obj(obj)

        _obj = AnnotatedSqlQuery.parse_obj({
            "sql_text":
            obj.get("sql_text"),
            "database":
            obj.get("database"),
            "var_schema":
            obj.get("schema"),
            "corresponding_question":
            obj.get("corresponding_question"),
            "additional_context":
            obj.get("additional_context"),
        })

        return _obj


from typing import Optional, List, Dict


class AnnotatedSqlQueryModel():

    def __init__(
        self,
        sql_text: str,
        # optional properties
        database: Optional[str] = None,
        var_schema: Optional[str] = None,
        corresponding_question: Optional[str] = None,
        additional_context: Optional[str] = None,
    ):
        """A model object representing the AnnotatedSqlQuery resource.

        Constructs an object of type AnnotatedSqlQuery with the provided properties.

        Parameters
        __________
        sql_text : str
            SQL query text
        database : str, optional
            Database associated with the SQL query
        var_schema : str, optional
            Schema associated with the SQL query
        corresponding_question : str, optional
            Natural language question that the SQL query answers
        additional_context : str, optional
            Free-form string for additional context about the query
        """

        self.sql_text = sql_text
        self.database = database
        self.var_schema = var_schema
        self.corresponding_question = corresponding_question
        self.additional_context = additional_context

    __properties = [
        "sql_text", "database", "schema", "corresponding_question",
        "additional_context"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return AnnotatedSqlQuery(
            sql_text=self.sql_text,
            database=self.database,
            var_schema=self.var_schema,
            corresponding_question=self.corresponding_question,
            additional_context=self.additional_context,
        )

    @classmethod
    def _from_model(cls, model) -> AnnotatedSqlQueryModel:
        return AnnotatedSqlQueryModel(
            sql_text=model.sql_text,
            database=model.database,
            var_schema=model.var_schema,
            corresponding_question=model.corresponding_question,
            additional_context=model.additional_context,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a AnnotatedSqlQuery.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the AnnotatedSqlQuery object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AnnotatedSqlQueryModel:
        """Creates an instance of AnnotatedSqlQuery from a dict.

        This method constructs a AnnotatedSqlQuery object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        AnnotatedSqlQuery
            A AnnotatedSqlQuery object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(AnnotatedSqlQuery.from_dict(obj))


AnnotatedSqlQuery._model_class = AnnotatedSqlQueryModel
