# coding: utf-8
"""
    Cortex Analyst API.

    The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict

from typing import Any, ClassVar, Dict, List, Optional


class FastGenerationResponse(BaseModel):
    """A model object representing the FastGenerationResponse resource.

    Constructs an object of type FastGenerationResponse with the provided properties.

    Parameters
    __________
    json_proto : object, optional
        A JSON-mapped FastGenerationResponse protobuf
    """

    json_proto: Optional[Dict[str, Any]] = None

    __properties = ["json_proto"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FastGenerationResponse:
        """Create an instance of FastGenerationResponse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> FastGenerationResponse:
        """Create an instance of FastGenerationResponse from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return FastGenerationResponse.parse_obj(obj)

        _obj = FastGenerationResponse.parse_obj({
            "json_proto":
            obj.get("json_proto"),
        })

        return _obj


from typing import Optional, List, Dict


class FastGenerationResponseModel():

    def __init__(
        self,  # optional properties
        json_proto: Optional[object] = None,
    ):
        """A model object representing the FastGenerationResponse resource.

        Constructs an object of type FastGenerationResponse with the provided properties.

        Parameters
        __________
        json_proto : object, optional
            A JSON-mapped FastGenerationResponse protobuf
        """

        self.json_proto = json_proto

    __properties = ["json_proto"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return FastGenerationResponse(json_proto=self.json_proto, )

    @classmethod
    def _from_model(cls, model) -> FastGenerationResponseModel:
        return FastGenerationResponseModel(json_proto=model.json_proto, )

    def to_dict(self):
        """Creates a dictionary of the properties from a FastGenerationResponse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the FastGenerationResponse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> FastGenerationResponseModel:
        """Creates an instance of FastGenerationResponse from a dict.

        This method constructs a FastGenerationResponse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        FastGenerationResponse
            A FastGenerationResponse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(FastGenerationResponse.from_dict(obj))


FastGenerationResponse._model_class = FastGenerationResponseModel
