# coding: utf-8
"""
    Cortex Analyst API.

    The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.cortex_analyst._generated.models.message_object import MessageObject

from snowflake.core.cortex_analyst._generated.models.semantic_model_selection import SemanticModelSelection

from snowflake.core.cortex_analyst._generated.models.warning import Warning

from pydantic import BaseModel, ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class SendMessageResponse(BaseModel):
    """A model object representing the SendMessageResponse resource.

    Constructs an object of type SendMessageResponse with the provided properties.

    Parameters
    __________
    message : MessageObject

    request_id : str, optional
        Unique request ID
    warnings : List[Warning], optional

    semantic_model_selection : SemanticModelSelection, optional

    response_metadata : object, optional
    """

    message: MessageObject

    request_id: Optional[StrictStr] = None

    warnings: Optional[List[Warning]] = None

    semantic_model_selection: Optional[SemanticModelSelection] = None

    response_metadata: Optional[Dict[str, Any]] = None

    __properties = [
        "message", "request_id", "warnings", "semantic_model_selection",
        "response_metadata"
    ]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SendMessageResponse:
        """Create an instance of SendMessageResponse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of message
        if self.message:
            _dict['message'] = self.message.to_dict()

        # override the default output from pydantic by calling `to_dict()` of each item in warnings (list)
        _items = []
        if self.warnings:
            for _item in self.warnings:
                if _item:
                    _items.append(_item.to_dict())
            _dict['warnings'] = _items

        # override the default output from pydantic by calling `to_dict()` of semantic_model_selection
        if self.semantic_model_selection:
            _dict[
                'semantic_model_selection'] = self.semantic_model_selection.to_dict(
                )

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> SendMessageResponse:
        """Create an instance of SendMessageResponse from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return SendMessageResponse.parse_obj(obj)

        _obj = SendMessageResponse.parse_obj({
            "message":
            MessageObject.from_dict(obj.get("message"))
            if obj.get("message") is not None else None,
            "request_id":
            obj.get("request_id"),
            "warnings":
            [Warning.from_dict(_item) for _item in obj.get("warnings")]
            if obj.get("warnings") is not None else None,
            "semantic_model_selection":
            SemanticModelSelection.from_dict(
                obj.get("semantic_model_selection"))
            if obj.get("semantic_model_selection") is not None else None,
            "response_metadata":
            obj.get("response_metadata"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.cortex_analyst._generated.models.message_object import MessageObject

from snowflake.core.cortex_analyst._generated.models.semantic_model_selection import SemanticModelSelection

from snowflake.core.cortex_analyst._generated.models.warning import Warning


class SendMessageResponseModel():

    def __init__(
        self,
        message: MessageObject,
        # optional properties
        request_id: Optional[str] = None,
        warnings: Optional[List[Warning]] = None,
        semantic_model_selection: Optional[SemanticModelSelection] = None,
        response_metadata: Optional[object] = None,
    ):
        """A model object representing the SendMessageResponse resource.

        Constructs an object of type SendMessageResponse with the provided properties.

        Parameters
        __________
        message : MessageObject

        request_id : str, optional
            Unique request ID
        warnings : List[Warning], optional

        semantic_model_selection : SemanticModelSelection, optional

        response_metadata : object, optional
        """

        self.message = message
        self.request_id = request_id
        self.warnings = warnings
        self.semantic_model_selection = semantic_model_selection
        self.response_metadata = response_metadata

    __properties = [
        "message", "request_id", "warnings", "semantic_model_selection",
        "response_metadata"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return SendMessageResponse(
            message=self.message._to_model()
            if self.message is not None else None,
            request_id=self.request_id,
            warnings=[x._to_model() for x in self.warnings]
            if self.warnings is not None else None,
            semantic_model_selection=self.semantic_model_selection._to_model()
            if self.semantic_model_selection is not None else None,
            response_metadata=self.response_metadata,
        )

    @classmethod
    def _from_model(cls, model) -> SendMessageResponseModel:
        return SendMessageResponseModel(
            message=MessageObjectModel._from_model(model.message)
            if model.message is not None else None,
            request_id=model.request_id,
            warnings=[WarningModel._from_model(x) for x in model.warnings]
            if model.warnings is not None else None,
            semantic_model_selection=SemanticModelSelectionModel._from_model(
                model.semantic_model_selection)
            if model.semantic_model_selection is not None else None,
            response_metadata=model.response_metadata,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a SendMessageResponse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the SendMessageResponse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> SendMessageResponseModel:
        """Creates an instance of SendMessageResponse from a dict.

        This method constructs a SendMessageResponse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        SendMessageResponse
            A SendMessageResponse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(SendMessageResponse.from_dict(obj))


SendMessageResponse._model_class = SendMessageResponseModel
