# coding: utf-8
"""
    Snowflake Database API.

    The Snowflake Database API is a REST API that you can use to access, update, and perform certain actions on Database resource in Snowflake.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.database._generated.models.point_of_time import PointOfTime

from datetime import datetime

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator

from typing import Any, ClassVar, Dict, List, Optional

from typing_extensions import Annotated


class DatabaseClone(BaseModel):
    """A model object representing the DatabaseClone resource.

    Constructs an object of type DatabaseClone with the provided properties.

    Parameters
    __________
    name : str
        A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
    point_of_time : PointOfTime, optional

    created_on : datetime, optional
        Date and time the database was created.
    kind : str,  default 'PERMANENT'
        Database type, permanent (default) or transient.
    is_default : bool, optional
        Whether the database is the default database for a user.
    is_current : bool, optional
        Current database for the session.
    origin : str, optional

    owner : str, optional
        Name of the role that owns the database.
    comment : str, optional
        Optional comment in which to store information related to the database.
    options : str, optional

    retention_time : int, optional
        Number of days that historical data is retained for Time Travel.
    dropped_on : datetime, optional
        Date and time the database was dropped.
    budget : str, optional
        Budget that defines a monthly spending limit on the compute costs for a Snowflake account or a custom group of Snowflake objects.
    owner_role_type : str, optional
        Type of role that owns the object, either ROLE or DATABASE_ROLE
    data_retention_time_in_days : int, optional
        Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the database, as well as specifying the default Time Travel retention time for all schemas created in the database.
    default_ddl_collation : str, optional
        Default collation specification for all schemas and tables added to the database. You an override the default at the schema and individual table levels.
    log_level : str, optional
        Severity level of messages that should be ingested and made available in the active event table. Currently, Snowflake supports only `TRACE`, `DEBUG`, `INFO`, `WARN`, `ERROR`, `FATAL` and `OFF`.
    max_data_extension_time_in_days : int, optional
        Maximum number of days for which Snowflake can extend the data retention period for tables in the database to prevent streams on the tables from becoming stale.
    suspend_task_after_num_failures : int, optional
        Maximum number of consecutive failed task runs before the current task is suspended automatically.
    trace_level : str, optional
        How trace events are ingested into the event table. Currently, Snowflake supports only `ALWAYS`, `ON_EVENT`, and `OFF`.
    user_task_managed_initial_warehouse_size : str, optional
        Size of the compute resources to provision for the first run of the serverless task, before a task history is available for Snowflake to determine an ideal size.
    user_task_timeout_ms : int, optional
        Time limit, in milliseconds, for a single run of the task before it times out.
    serverless_task_min_statement_size : str, optional
        Specifies the minimum allowed warehouse size for the serverless task. Minimum XSMALL, Maximum XXLARGE.
    serverless_task_max_statement_size : str, optional
        Specifies the maximum allowed warehouse size for the serverless task. Minimum XSMALL, Maximum XXLARGE.
    """

    point_of_time: Optional[PointOfTime] = None

    created_on: Optional[datetime] = None

    name: Annotated[str, Field(strict=True)]

    kind: Optional[StrictStr] = 'PERMANENT'

    is_default: Optional[StrictBool] = None

    is_current: Optional[StrictBool] = None

    origin: Optional[StrictStr] = None

    owner: Optional[StrictStr] = None

    comment: Optional[StrictStr] = None

    options: Optional[StrictStr] = None

    retention_time: Optional[StrictInt] = None

    dropped_on: Optional[datetime] = None

    budget: Optional[StrictStr] = None

    owner_role_type: Optional[StrictStr] = None

    data_retention_time_in_days: Optional[StrictInt] = None

    default_ddl_collation: Optional[StrictStr] = None

    log_level: Optional[StrictStr] = None

    max_data_extension_time_in_days: Optional[StrictInt] = None

    suspend_task_after_num_failures: Optional[StrictInt] = None

    trace_level: Optional[StrictStr] = None

    user_task_managed_initial_warehouse_size: Optional[StrictStr] = None

    user_task_timeout_ms: Optional[StrictInt] = None

    serverless_task_min_statement_size: Optional[StrictStr] = None

    serverless_task_max_statement_size: Optional[StrictStr] = None

    __properties = [
        "created_on", "name", "kind", "is_default", "is_current", "origin",
        "owner", "comment", "options", "retention_time", "dropped_on",
        "budget", "owner_role_type", "data_retention_time_in_days",
        "default_ddl_collation", "log_level",
        "max_data_extension_time_in_days", "suspend_task_after_num_failures",
        "trace_level", "user_task_managed_initial_warehouse_size",
        "user_task_timeout_ms", "serverless_task_min_statement_size",
        "serverless_task_max_statement_size"
    ]

    @field_validator('name')
    def name_validate_regular_expression(cls, v):

        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('kind')
    def kind_validate_enum(cls, v):

        if v is None:
            return v
        if v not in ('PERMANENT', 'TRANSIENT'):
            raise ValueError(
                "must validate the enum values ('PERMANENT','TRANSIENT')")
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DatabaseClone:
        """Create an instance of DatabaseClone from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({
                "created_on",
                "is_default",
                "is_current",
                "origin",
                "owner",
                "options",
                "retention_time",
                "dropped_on",
                "budget",
                "owner_role_type",
            })

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of point_of_time
        if self.point_of_time:
            _dict['point_of_time'] = self.point_of_time.to_dict()

        # set to None if dropped_on (nullable) is None
        if self.dropped_on is None:
            _dict['dropped_on'] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> DatabaseClone:
        """Create an instance of DatabaseClone from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return DatabaseClone.parse_obj(obj)

        _obj = DatabaseClone.parse_obj({
            "point_of_time":
            PointOfTime.from_dict(obj.get("point_of_time"))
            if obj.get("point_of_time") is not None else None,
            "created_on":
            obj.get("created_on"),
            "name":
            obj.get("name"),
            "kind":
            obj.get("kind") if obj.get("kind") is not None else 'PERMANENT',
            "is_default":
            obj.get("is_default"),
            "is_current":
            obj.get("is_current"),
            "origin":
            obj.get("origin"),
            "owner":
            obj.get("owner"),
            "comment":
            obj.get("comment"),
            "options":
            obj.get("options"),
            "retention_time":
            obj.get("retention_time"),
            "dropped_on":
            obj.get("dropped_on"),
            "budget":
            obj.get("budget"),
            "owner_role_type":
            obj.get("owner_role_type"),
            "data_retention_time_in_days":
            obj.get("data_retention_time_in_days"),
            "default_ddl_collation":
            obj.get("default_ddl_collation"),
            "log_level":
            obj.get("log_level"),
            "max_data_extension_time_in_days":
            obj.get("max_data_extension_time_in_days"),
            "suspend_task_after_num_failures":
            obj.get("suspend_task_after_num_failures"),
            "trace_level":
            obj.get("trace_level"),
            "user_task_managed_initial_warehouse_size":
            obj.get("user_task_managed_initial_warehouse_size"),
            "user_task_timeout_ms":
            obj.get("user_task_timeout_ms"),
            "serverless_task_min_statement_size":
            obj.get("serverless_task_min_statement_size"),
            "serverless_task_max_statement_size":
            obj.get("serverless_task_max_statement_size"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.database._generated.models.point_of_time import PointOfTime


class DatabaseCloneModel():

    def __init__(
        self,
        name: str,
        # optional properties
        point_of_time: Optional[PointOfTime] = None,
        created_on: Optional[datetime] = None,
        kind: Optional[str] = 'PERMANENT',
        is_default: Optional[bool] = None,
        is_current: Optional[bool] = None,
        origin: Optional[str] = None,
        owner: Optional[str] = None,
        comment: Optional[str] = None,
        options: Optional[str] = None,
        retention_time: Optional[int] = None,
        dropped_on: Optional[datetime] = None,
        budget: Optional[str] = None,
        owner_role_type: Optional[str] = None,
        data_retention_time_in_days: Optional[int] = None,
        default_ddl_collation: Optional[str] = None,
        log_level: Optional[str] = None,
        max_data_extension_time_in_days: Optional[int] = None,
        suspend_task_after_num_failures: Optional[int] = None,
        trace_level: Optional[str] = None,
        user_task_managed_initial_warehouse_size: Optional[str] = None,
        user_task_timeout_ms: Optional[int] = None,
        serverless_task_min_statement_size: Optional[str] = None,
        serverless_task_max_statement_size: Optional[str] = None,
    ):
        """A model object representing the DatabaseClone resource.

        Constructs an object of type DatabaseClone with the provided properties.

        Parameters
        __________
        name : str
            A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
        point_of_time : PointOfTime, optional

        created_on : datetime, optional
            Date and time the database was created.
        kind : str,  default 'PERMANENT'
            Database type, permanent (default) or transient.
        is_default : bool, optional
            Whether the database is the default database for a user.
        is_current : bool, optional
            Current database for the session.
        origin : str, optional

        owner : str, optional
            Name of the role that owns the database.
        comment : str, optional
            Optional comment in which to store information related to the database.
        options : str, optional

        retention_time : int, optional
            Number of days that historical data is retained for Time Travel.
        dropped_on : datetime, optional
            Date and time the database was dropped.
        budget : str, optional
            Budget that defines a monthly spending limit on the compute costs for a Snowflake account or a custom group of Snowflake objects.
        owner_role_type : str, optional
            Type of role that owns the object, either ROLE or DATABASE_ROLE
        data_retention_time_in_days : int, optional
            Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the database, as well as specifying the default Time Travel retention time for all schemas created in the database.
        default_ddl_collation : str, optional
            Default collation specification for all schemas and tables added to the database. You an override the default at the schema and individual table levels.
        log_level : str, optional
            Severity level of messages that should be ingested and made available in the active event table. Currently, Snowflake supports only `TRACE`, `DEBUG`, `INFO`, `WARN`, `ERROR`, `FATAL` and `OFF`.
        max_data_extension_time_in_days : int, optional
            Maximum number of days for which Snowflake can extend the data retention period for tables in the database to prevent streams on the tables from becoming stale.
        suspend_task_after_num_failures : int, optional
            Maximum number of consecutive failed task runs before the current task is suspended automatically.
        trace_level : str, optional
            How trace events are ingested into the event table. Currently, Snowflake supports only `ALWAYS`, `ON_EVENT`, and `OFF`.
        user_task_managed_initial_warehouse_size : str, optional
            Size of the compute resources to provision for the first run of the serverless task, before a task history is available for Snowflake to determine an ideal size.
        user_task_timeout_ms : int, optional
            Time limit, in milliseconds, for a single run of the task before it times out.
        serverless_task_min_statement_size : str, optional
            Specifies the minimum allowed warehouse size for the serverless task. Minimum XSMALL, Maximum XXLARGE.
        serverless_task_max_statement_size : str, optional
            Specifies the maximum allowed warehouse size for the serverless task. Minimum XSMALL, Maximum XXLARGE.
        """

        self.point_of_time = point_of_time
        self.created_on = created_on
        self.name = name
        self.kind = kind
        self.is_default = is_default
        self.is_current = is_current
        self.origin = origin
        self.owner = owner
        self.comment = comment
        self.options = options
        self.retention_time = retention_time
        self.dropped_on = dropped_on
        self.budget = budget
        self.owner_role_type = owner_role_type
        self.data_retention_time_in_days = data_retention_time_in_days
        self.default_ddl_collation = default_ddl_collation
        self.log_level = log_level
        self.max_data_extension_time_in_days = max_data_extension_time_in_days
        self.suspend_task_after_num_failures = suspend_task_after_num_failures
        self.trace_level = trace_level
        self.user_task_managed_initial_warehouse_size = user_task_managed_initial_warehouse_size
        self.user_task_timeout_ms = user_task_timeout_ms
        self.serverless_task_min_statement_size = serverless_task_min_statement_size
        self.serverless_task_max_statement_size = serverless_task_max_statement_size

    __properties = [
        "created_on", "name", "kind", "is_default", "is_current", "origin",
        "owner", "comment", "options", "retention_time", "dropped_on",
        "budget", "owner_role_type", "data_retention_time_in_days",
        "default_ddl_collation", "log_level",
        "max_data_extension_time_in_days", "suspend_task_after_num_failures",
        "trace_level", "user_task_managed_initial_warehouse_size",
        "user_task_timeout_ms", "serverless_task_min_statement_size",
        "serverless_task_max_statement_size"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return DatabaseClone(
            point_of_time=self.point_of_time._to_model()
            if self.point_of_time is not None else None,
            created_on=self.created_on,
            name=self.name,
            kind=self.kind,
            is_default=self.is_default,
            is_current=self.is_current,
            origin=self.origin,
            owner=self.owner,
            comment=self.comment,
            options=self.options,
            retention_time=self.retention_time,
            dropped_on=self.dropped_on,
            budget=self.budget,
            owner_role_type=self.owner_role_type,
            data_retention_time_in_days=self.data_retention_time_in_days,
            default_ddl_collation=self.default_ddl_collation,
            log_level=self.log_level,
            max_data_extension_time_in_days=self.
            max_data_extension_time_in_days,
            suspend_task_after_num_failures=self.
            suspend_task_after_num_failures,
            trace_level=self.trace_level,
            user_task_managed_initial_warehouse_size=self.
            user_task_managed_initial_warehouse_size,
            user_task_timeout_ms=self.user_task_timeout_ms,
            serverless_task_min_statement_size=self.
            serverless_task_min_statement_size,
            serverless_task_max_statement_size=self.
            serverless_task_max_statement_size,
        )

    @classmethod
    def _from_model(cls, model) -> DatabaseCloneModel:
        return DatabaseCloneModel(
            point_of_time=PointOfTimeModel._from_model(model.point_of_time)
            if model.point_of_time is not None else None,
            created_on=model.created_on,
            name=model.name,
            kind=model.kind,
            is_default=model.is_default,
            is_current=model.is_current,
            origin=model.origin,
            owner=model.owner,
            comment=model.comment,
            options=model.options,
            retention_time=model.retention_time,
            dropped_on=model.dropped_on,
            budget=model.budget,
            owner_role_type=model.owner_role_type,
            data_retention_time_in_days=model.data_retention_time_in_days,
            default_ddl_collation=model.default_ddl_collation,
            log_level=model.log_level,
            max_data_extension_time_in_days=model.
            max_data_extension_time_in_days,
            suspend_task_after_num_failures=model.
            suspend_task_after_num_failures,
            trace_level=model.trace_level,
            user_task_managed_initial_warehouse_size=model.
            user_task_managed_initial_warehouse_size,
            user_task_timeout_ms=model.user_task_timeout_ms,
            serverless_task_min_statement_size=model.
            serverless_task_min_statement_size,
            serverless_task_max_statement_size=model.
            serverless_task_max_statement_size,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a DatabaseClone.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the DatabaseClone object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> DatabaseCloneModel:
        """Creates an instance of DatabaseClone from a dict.

        This method constructs a DatabaseClone object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        DatabaseClone
            A DatabaseClone object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(DatabaseClone.from_dict(obj))


DatabaseClone._model_class = DatabaseCloneModel
