# coding: utf-8
"""
    Snowflake Database Role API.

    The Snowflake Database Role API is a REST API that you can use to access, update, and perform certain actions on Database Role resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from datetime import datetime

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator

from typing import Any, ClassVar, Dict, List, Optional

from typing_extensions import Annotated


class DatabaseRole(BaseModel):
    """A model object representing the DatabaseRole resource.

    Constructs an object of type DatabaseRole with the provided properties.

    Parameters
    __________
    name : str
        Name of the database role
    comment : str, optional
        User comment associated to an object in the dictionary
    created_on : datetime, optional
        Date and time when the database role was created
    granted_to_roles : int, optional
        How many roles this database role has been granted to
    granted_to_database_roles : int, optional
        How many database roles this database role has been granted to
    granted_database_roles : int, optional
        How many database roles this database role has been granted
    owner : str, optional
        Role that owns the database role
    owner_role_type : str, optional
        The type of role that owns the database role
    """

    name: Annotated[str, Field(strict=True)]

    comment: Optional[StrictStr] = None

    created_on: Optional[datetime] = None

    granted_to_roles: Optional[StrictInt] = None

    granted_to_database_roles: Optional[StrictInt] = None

    granted_database_roles: Optional[StrictInt] = None

    owner: Optional[Annotated[str, Field(strict=True)]] = None

    owner_role_type: Optional[Annotated[str, Field(strict=True)]] = None

    __properties = [
        "name", "comment", "created_on", "granted_to_roles",
        "granted_to_database_roles", "granted_database_roles", "owner",
        "owner_role_type"
    ]

    @field_validator('name')
    def name_validate_regular_expression(cls, v):

        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('owner')
    def owner_validate_regular_expression(cls, v):

        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('owner_role_type')
    def owner_role_type_validate_regular_expression(cls, v):

        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DatabaseRole:
        """Create an instance of DatabaseRole from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({
                "created_on",
                "granted_to_roles",
                "granted_to_database_roles",
                "granted_database_roles",
                "owner",
                "owner_role_type",
            })

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> DatabaseRole:
        """Create an instance of DatabaseRole from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return DatabaseRole.parse_obj(obj)

        _obj = DatabaseRole.parse_obj({
            "name":
            obj.get("name"),
            "comment":
            obj.get("comment"),
            "created_on":
            obj.get("created_on"),
            "granted_to_roles":
            obj.get("granted_to_roles"),
            "granted_to_database_roles":
            obj.get("granted_to_database_roles"),
            "granted_database_roles":
            obj.get("granted_database_roles"),
            "owner":
            obj.get("owner"),
            "owner_role_type":
            obj.get("owner_role_type"),
        })

        return _obj


from typing import Optional, List, Dict


class DatabaseRoleModel():

    def __init__(
        self,
        name: str,
        # optional properties
        comment: Optional[str] = None,
        created_on: Optional[datetime] = None,
        granted_to_roles: Optional[int] = None,
        granted_to_database_roles: Optional[int] = None,
        granted_database_roles: Optional[int] = None,
        owner: Optional[str] = None,
        owner_role_type: Optional[str] = None,
    ):
        """A model object representing the DatabaseRole resource.

        Constructs an object of type DatabaseRole with the provided properties.

        Parameters
        __________
        name : str
            Name of the database role
        comment : str, optional
            User comment associated to an object in the dictionary
        created_on : datetime, optional
            Date and time when the database role was created
        granted_to_roles : int, optional
            How many roles this database role has been granted to
        granted_to_database_roles : int, optional
            How many database roles this database role has been granted to
        granted_database_roles : int, optional
            How many database roles this database role has been granted
        owner : str, optional
            Role that owns the database role
        owner_role_type : str, optional
            The type of role that owns the database role
        """

        self.name = name
        self.comment = comment
        self.created_on = created_on
        self.granted_to_roles = granted_to_roles
        self.granted_to_database_roles = granted_to_database_roles
        self.granted_database_roles = granted_database_roles
        self.owner = owner
        self.owner_role_type = owner_role_type

    __properties = [
        "name", "comment", "created_on", "granted_to_roles",
        "granted_to_database_roles", "granted_database_roles", "owner",
        "owner_role_type"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return DatabaseRole(
            name=self.name,
            comment=self.comment,
            created_on=self.created_on,
            granted_to_roles=self.granted_to_roles,
            granted_to_database_roles=self.granted_to_database_roles,
            granted_database_roles=self.granted_database_roles,
            owner=self.owner,
            owner_role_type=self.owner_role_type,
        )

    @classmethod
    def _from_model(cls, model) -> DatabaseRoleModel:
        return DatabaseRoleModel(
            name=model.name,
            comment=model.comment,
            created_on=model.created_on,
            granted_to_roles=model.granted_to_roles,
            granted_to_database_roles=model.granted_to_database_roles,
            granted_database_roles=model.granted_database_roles,
            owner=model.owner,
            owner_role_type=model.owner_role_type,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a DatabaseRole.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the DatabaseRole object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> DatabaseRoleModel:
        """Creates an instance of DatabaseRole from a dict.

        This method constructs a DatabaseRole object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        DatabaseRole
            A DatabaseRole object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(DatabaseRole.from_dict(obj))


DatabaseRole._model_class = DatabaseRoleModel
