# coding: utf-8
"""
    Snowflake Event Table API.

    The Snowflake Event Table API is a REST API that you can use to access, update, and perform certain actions on Event Table resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class EventTableColumn(BaseModel):
    """A model object representing the EventTableColumn resource.

    Constructs an object of type EventTableColumn with the provided properties.

    Parameters
    __________
    name : str, optional
        Column name
    datatype : str, optional
        The data type for the column
    nullable : bool, optional
        Specifies that the column does allow NULL values or not
    default : str, optional
        Specifies whether a default value is automatically inserted in the column if a value is not explicitly specified via an INSERT or CREATE TABLE AS SELECT statement
    primary_key : bool, optional
        A primary key is the column or columns that contain values that uniquely identify each row in a table
    unique_key : bool, optional
        Unique keys are columns in a table that uniquely identify items in the rows. This sounds a lot like a primary key, but the main difference is that unique keys can have NULL values.
    check : str, optional

    expression : str, optional

    comment : str, optional
        Specifies a comment for the column
    """

    name: Optional[StrictStr] = None

    datatype: Optional[StrictStr] = None

    nullable: Optional[StrictBool] = None

    default: Optional[StrictStr] = None

    primary_key: Optional[StrictBool] = None

    unique_key: Optional[StrictBool] = None

    check: Optional[StrictStr] = None

    expression: Optional[StrictStr] = None

    comment: Optional[StrictStr] = None

    __properties = [
        "name", "datatype", "nullable", "default", "primary_key", "unique_key",
        "check", "expression", "comment"
    ]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EventTableColumn:
        """Create an instance of EventTableColumn from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> EventTableColumn:
        """Create an instance of EventTableColumn from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return EventTableColumn.parse_obj(obj)

        _obj = EventTableColumn.parse_obj({
            "name": obj.get("name"),
            "datatype": obj.get("datatype"),
            "nullable": obj.get("nullable"),
            "default": obj.get("default"),
            "primary_key": obj.get("primary_key"),
            "unique_key": obj.get("unique_key"),
            "check": obj.get("check"),
            "expression": obj.get("expression"),
            "comment": obj.get("comment"),
        })

        return _obj


from typing import Optional, List, Dict


class EventTableColumnModel():

    def __init__(
        self,  # optional properties
        name: Optional[str] = None,
        datatype: Optional[str] = None,
        nullable: Optional[bool] = None,
        default: Optional[str] = None,
        primary_key: Optional[bool] = None,
        unique_key: Optional[bool] = None,
        check: Optional[str] = None,
        expression: Optional[str] = None,
        comment: Optional[str] = None,
    ):
        """A model object representing the EventTableColumn resource.

        Constructs an object of type EventTableColumn with the provided properties.

        Parameters
        __________
        name : str, optional
            Column name
        datatype : str, optional
            The data type for the column
        nullable : bool, optional
            Specifies that the column does allow NULL values or not
        default : str, optional
            Specifies whether a default value is automatically inserted in the column if a value is not explicitly specified via an INSERT or CREATE TABLE AS SELECT statement
        primary_key : bool, optional
            A primary key is the column or columns that contain values that uniquely identify each row in a table
        unique_key : bool, optional
            Unique keys are columns in a table that uniquely identify items in the rows. This sounds a lot like a primary key, but the main difference is that unique keys can have NULL values.
        check : str, optional

        expression : str, optional

        comment : str, optional
            Specifies a comment for the column
        """

        self.name = name
        self.datatype = datatype
        self.nullable = nullable
        self.default = default
        self.primary_key = primary_key
        self.unique_key = unique_key
        self.check = check
        self.expression = expression
        self.comment = comment

    __properties = [
        "name", "datatype", "nullable", "default", "primary_key", "unique_key",
        "check", "expression", "comment"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return EventTableColumn(
            name=self.name,
            datatype=self.datatype,
            nullable=self.nullable,
            default=self.default,
            primary_key=self.primary_key,
            unique_key=self.unique_key,
            check=self.check,
            expression=self.expression,
            comment=self.comment,
        )

    @classmethod
    def _from_model(cls, model) -> EventTableColumnModel:
        return EventTableColumnModel(
            name=model.name,
            datatype=model.datatype,
            nullable=model.nullable,
            default=model.default,
            primary_key=model.primary_key,
            unique_key=model.unique_key,
            check=model.check,
            expression=model.expression,
            comment=model.comment,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a EventTableColumn.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the EventTableColumn object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> EventTableColumnModel:
        """Creates an instance of EventTableColumn from a dict.

        This method constructs a EventTableColumn object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        EventTableColumn
            A EventTableColumn object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(EventTableColumn.from_dict(obj))


EventTableColumn._model_class = EventTableColumnModel
