# coding: utf-8
"""
    Snowflake Function API.

    The Snowflake Function API is a REST API that allows caller to create, execute and drop functions in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

import snowflake.core.function._generated.models
from snowflake.core.function._generated.models import *

from typing import Union

from snowflake.core.function._generated.models.function_argument import FunctionArgument

from datetime import datetime

from importlib import import_module

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr, field_validator

from typing import Any, ClassVar, Dict, List, Optional, Union


class Function(BaseModel):
    """A model object representing the Function resource.

    Constructs an object of type Function with the provided properties.

    Parameters
    __________
    name : str
        Specifies the name for the function, must be unique for the schema in which the function is created
    arguments : List[FunctionArgument]

    returns : str,  default 'TEXT'
        Specifies the type for the function return value.
    max_batch_rows : int, optional
        Specifies the max rows for batch operation.
    created_on : datetime, optional
        Date and time when the function was created.
    signature : str, optional
        Function's arguments.
    language : str, optional
        Function's language.
    body : str, optional
        Function's body.
    """

    name: StrictStr

    arguments: List[FunctionArgument]

    returns: Optional[StrictStr] = 'TEXT'

    max_batch_rows: Optional[StrictInt] = None

    created_on: Optional[datetime] = None

    signature: Optional[StrictStr] = None

    language: Optional[StrictStr] = None

    body: Optional[StrictStr] = None

    __properties = [
        "function_type", "name", "arguments", "returns", "max_batch_rows",
        "created_on", "signature", "language", "body"
    ]

    @field_validator('returns')
    def returns_validate_enum(cls, v):

        if v is None:
            return v
        if v not in ('FIXED', 'INT', 'REAL', 'NUMBER', 'TEXT', 'BOOLEAN',
                     'DATE', 'TIME', 'TIMESTAMP_TZ', 'TIMESTAMP_LTZ',
                     'TIMESTAMP_NTZ'):
            raise ValueError(
                "must validate the enum values ('FIXED','INT','REAL','NUMBER','TEXT','BOOLEAN','DATE','TIME','TIMESTAMP_TZ','TIMESTAMP_LTZ','TIMESTAMP_NTZ')"
            )
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'function_type'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'service-function': 'ServiceFunction'
    }

    @classmethod
    def get_discriminator_value(cls, obj: dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data."""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    __discriminator_value_to_type: ClassVar[Dict[str, str]] = {
        'ServiceFunction': 'service-function',
    }

    @classmethod
    def get_child_model_discriminator_value(cls, child_model: str) -> str:
        return cls.__discriminator_value_to_type[child_model]

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Union[ServiceFunction]:
        """Create an instance of Function from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in arguments (list)
        _items = []
        if self.arguments:
            for _item in self.arguments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['arguments'] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Union[ServiceFunction]:
        """Create an instance of Function from a dict."""

        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type:
            klass = getattr(snowflake.core.function._generated.models,
                            object_type)
            return klass.from_dict(obj)
        else:
            raise ValueError(
                "Function failed to lookup discriminator value from " +
                json.dumps(obj) + ". Discriminator property name: " +
                cls.__discriminator_property_name + ", mapping: " +
                json.dumps(cls.__discriminator_value_class_map))


from typing import Optional, List, Dict

from snowflake.core.function._generated.models.function_argument import FunctionArgument


class FunctionModel():

    def __init__(
        self,
        name: str,
        arguments: List[FunctionArgument],
        # optional properties
        returns: Optional[str] = 'TEXT',
        max_batch_rows: Optional[int] = None,
        created_on: Optional[datetime] = None,
        signature: Optional[str] = None,
        language: Optional[str] = None,
        body: Optional[str] = None,
    ):
        """A model object representing the Function resource.

        Constructs an object of type Function with the provided properties.

        Parameters
        __________
        name : str
            Specifies the name for the function, must be unique for the schema in which the function is created
        arguments : List[FunctionArgument]

        returns : str,  default 'TEXT'
            Specifies the type for the function return value.
        max_batch_rows : int, optional
            Specifies the max rows for batch operation.
        created_on : datetime, optional
            Date and time when the function was created.
        signature : str, optional
            Function's arguments.
        language : str, optional
            Function's language.
        body : str, optional
            Function's body.
        """

        self.name = name
        self.arguments = arguments
        self.returns = returns
        self.max_batch_rows = max_batch_rows
        self.created_on = created_on
        self.signature = signature
        self.language = language
        self.body = body

    __properties = [
        "function_type", "name", "arguments", "returns", "max_batch_rows",
        "created_on", "signature", "language", "body"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Function(
            name=self.name,
            arguments=[x._to_model() for x in self.arguments]
            if self.arguments is not None else None,
            returns=self.returns,
            max_batch_rows=self.max_batch_rows,
            created_on=self.created_on,
            signature=self.signature,
            language=self.language,
            body=self.body,
        )

    @classmethod
    def _from_model(cls, model) -> FunctionModel:
        return model.__class__._model_class._from_model(model)

    def to_dict(self):
        """Creates a dictionary of the properties from a Function.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Function object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> Union[ServiceFunctionModel]:
        """Creates an instance of Function from a dict.

        This method constructs a Function object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Function
            A Function object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Function.from_dict(obj))


Function._model_class = FunctionModel
