# coding: utf-8
"""
    Snowflake Grant API.

    The Snowflake Grant API is a REST API that you can use to show or manage privileges that have been provided to users and roles in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from datetime import datetime

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class Grant(BaseModel):
    """A model object representing the Grant resource.

    Constructs an object of type Grant with the provided properties.

    Parameters
    __________
    privileges : List[str], optional
        Privilege type
    grant_option : bool, optional
        Can grantee pass this privilege down?
    created_on : datetime, optional

    grantee_type : str, optional
        Entity type being granted to
    grantee_name : str, optional
        Specific name of object being granted to
    securable_type : str, optional
        Type of object granted on
    securable_name : str, optional
        Name of specific object granted on (not name of privilege!)
    granted_by_role_type : str, optional
        Type of role that granted this privilege to this grantee
    granted_by_name : str, optional
        The role that granted this privilege to this grantee
    """

    privileges: Optional[List[StrictStr]] = None

    grant_option: Optional[StrictBool] = None

    created_on: Optional[datetime] = None

    grantee_type: Optional[StrictStr] = None

    grantee_name: Optional[StrictStr] = None

    securable_type: Optional[StrictStr] = None

    securable_name: Optional[StrictStr] = None

    granted_by_role_type: Optional[StrictStr] = None

    granted_by_name: Optional[StrictStr] = None

    __properties = [
        "privileges", "grant_option", "created_on", "grantee_type",
        "grantee_name", "securable_type", "securable_name",
        "granted_by_role_type", "granted_by_name"
    ]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Grant:
        """Create an instance of Grant from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Grant:
        """Create an instance of Grant from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return Grant.parse_obj(obj)

        _obj = Grant.parse_obj({
            "privileges":
            obj.get("privileges"),
            "grant_option":
            obj.get("grant_option"),
            "created_on":
            obj.get("created_on"),
            "grantee_type":
            obj.get("grantee_type"),
            "grantee_name":
            obj.get("grantee_name"),
            "securable_type":
            obj.get("securable_type"),
            "securable_name":
            obj.get("securable_name"),
            "granted_by_role_type":
            obj.get("granted_by_role_type"),
            "granted_by_name":
            obj.get("granted_by_name"),
        })

        return _obj


from typing import Optional, List, Dict


class GrantModel():

    def __init__(
        self,  # optional properties
        privileges: Optional[List[str]] = None,
        grant_option: Optional[bool] = None,
        created_on: Optional[datetime] = None,
        grantee_type: Optional[str] = None,
        grantee_name: Optional[str] = None,
        securable_type: Optional[str] = None,
        securable_name: Optional[str] = None,
        granted_by_role_type: Optional[str] = None,
        granted_by_name: Optional[str] = None,
    ):
        """A model object representing the Grant resource.

        Constructs an object of type Grant with the provided properties.

        Parameters
        __________
        privileges : List[str], optional
            Privilege type
        grant_option : bool, optional
            Can grantee pass this privilege down?
        created_on : datetime, optional

        grantee_type : str, optional
            Entity type being granted to
        grantee_name : str, optional
            Specific name of object being granted to
        securable_type : str, optional
            Type of object granted on
        securable_name : str, optional
            Name of specific object granted on (not name of privilege!)
        granted_by_role_type : str, optional
            Type of role that granted this privilege to this grantee
        granted_by_name : str, optional
            The role that granted this privilege to this grantee
        """

        self.privileges = privileges
        self.grant_option = grant_option
        self.created_on = created_on
        self.grantee_type = grantee_type
        self.grantee_name = grantee_name
        self.securable_type = securable_type
        self.securable_name = securable_name
        self.granted_by_role_type = granted_by_role_type
        self.granted_by_name = granted_by_name

    __properties = [
        "privileges", "grant_option", "created_on", "grantee_type",
        "grantee_name", "securable_type", "securable_name",
        "granted_by_role_type", "granted_by_name"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Grant(
            privileges=self.privileges,
            grant_option=self.grant_option,
            created_on=self.created_on,
            grantee_type=self.grantee_type,
            grantee_name=self.grantee_name,
            securable_type=self.securable_type,
            securable_name=self.securable_name,
            granted_by_role_type=self.granted_by_role_type,
            granted_by_name=self.granted_by_name,
        )

    @classmethod
    def _from_model(cls, model) -> GrantModel:
        return GrantModel(
            privileges=model.privileges,
            grant_option=model.grant_option,
            created_on=model.created_on,
            grantee_type=model.grantee_type,
            grantee_name=model.grantee_name,
            securable_type=model.securable_type,
            securable_name=model.securable_name,
            granted_by_role_type=model.granted_by_role_type,
            granted_by_name=model.granted_by_name,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a Grant.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Grant object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> GrantModel:
        """Creates an instance of Grant from a dict.

        This method constructs a Grant object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Grant
            A Grant object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Grant.from_dict(obj))


Grant._model_class = GrantModel
