# coding: utf-8
"""
    Snowflake Iceberg Table API.

    The Snowflake Iceberg Table API is a REST API that you can use to access, update, and perform certain actions on Iceberg Table resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class IcebergTableFromDelta(BaseModel):
    """A model object representing the IcebergTableFromDelta resource.

    Constructs an object of type IcebergTableFromDelta with the provided properties.

    Parameters
    __________
    name : str
        Specifies the name for the table, must be unique for the schema in which the table is created
    base_location : str
        Specifies a relative path from the table’s EXTERNAL_VOLUME location to a directory where Snowflake can access your Delta table files.
    external_volume : str, optional
        Specifies the name of the external volume to use for the table
    replace_invalid_characters : bool, optional
        Specifies whether to replace invalid characters in the column names
    catalog : str, optional
        Specifies the name of the catalog integration to use for the table
    comment : str, optional
        Specifies a comment for the table
    """

    name: StrictStr

    external_volume: Optional[StrictStr] = None

    replace_invalid_characters: Optional[StrictBool] = None

    base_location: StrictStr

    catalog: Optional[StrictStr] = None

    comment: Optional[StrictStr] = None

    __properties = [
        "name", "external_volume", "replace_invalid_characters",
        "base_location", "catalog", "comment"
    ]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IcebergTableFromDelta:
        """Create an instance of IcebergTableFromDelta from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> IcebergTableFromDelta:
        """Create an instance of IcebergTableFromDelta from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return IcebergTableFromDelta.parse_obj(obj)

        _obj = IcebergTableFromDelta.parse_obj({
            "name":
            obj.get("name"),
            "external_volume":
            obj.get("external_volume"),
            "replace_invalid_characters":
            obj.get("replace_invalid_characters"),
            "base_location":
            obj.get("base_location"),
            "catalog":
            obj.get("catalog"),
            "comment":
            obj.get("comment"),
        })

        return _obj


from typing import Optional, List, Dict


class IcebergTableFromDeltaModel():

    def __init__(
        self,
        name: str,
        base_location: str,
        # optional properties
        external_volume: Optional[str] = None,
        replace_invalid_characters: Optional[bool] = None,
        catalog: Optional[str] = None,
        comment: Optional[str] = None,
    ):
        """A model object representing the IcebergTableFromDelta resource.

        Constructs an object of type IcebergTableFromDelta with the provided properties.

        Parameters
        __________
        name : str
            Specifies the name for the table, must be unique for the schema in which the table is created
        base_location : str
            Specifies a relative path from the table’s EXTERNAL_VOLUME location to a directory where Snowflake can access your Delta table files.
        external_volume : str, optional
            Specifies the name of the external volume to use for the table
        replace_invalid_characters : bool, optional
            Specifies whether to replace invalid characters in the column names
        catalog : str, optional
            Specifies the name of the catalog integration to use for the table
        comment : str, optional
            Specifies a comment for the table
        """

        self.name = name
        self.external_volume = external_volume
        self.replace_invalid_characters = replace_invalid_characters
        self.base_location = base_location
        self.catalog = catalog
        self.comment = comment

    __properties = [
        "name", "external_volume", "replace_invalid_characters",
        "base_location", "catalog", "comment"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return IcebergTableFromDelta(
            name=self.name,
            external_volume=self.external_volume,
            replace_invalid_characters=self.replace_invalid_characters,
            base_location=self.base_location,
            catalog=self.catalog,
            comment=self.comment,
        )

    @classmethod
    def _from_model(cls, model) -> IcebergTableFromDeltaModel:
        return IcebergTableFromDeltaModel(
            name=model.name,
            external_volume=model.external_volume,
            replace_invalid_characters=model.replace_invalid_characters,
            base_location=model.base_location,
            catalog=model.catalog,
            comment=model.comment,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a IcebergTableFromDelta.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the IcebergTableFromDelta object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> IcebergTableFromDeltaModel:
        """Creates an instance of IcebergTableFromDelta from a dict.

        This method constructs a IcebergTableFromDelta object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        IcebergTableFromDelta
            A IcebergTableFromDelta object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(IcebergTableFromDelta.from_dict(obj))


IcebergTableFromDelta._model_class = IcebergTableFromDeltaModel
