# coding: utf-8
"""
    Snowflake Iceberg Table API.

    The Snowflake Iceberg Table API is a REST API that you can use to access, update, and perform certain actions on Iceberg Table resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class IcebergTableLike(BaseModel):
    """A model object representing the IcebergTableLike resource.

    Constructs an object of type IcebergTableLike with the provided properties.

    Parameters
    __________
    name : str
        Specifies the name for the table, must be unique for the schema in which the table is created
    cluster_by : List[str], optional
        Specifies one or more columns or column expressions in the table as the clustering key
    external_volume : str, optional
        Specifies the name of the external volume to use for the table
    base_location : str, optional
        Specifies the path to a directory where Snowflake can write data and metadata files for the table
    comment : str, optional
        Specifies a comment for the table
    """

    name: StrictStr

    cluster_by: Optional[List[StrictStr]] = None

    external_volume: Optional[StrictStr] = None

    base_location: Optional[StrictStr] = None

    comment: Optional[StrictStr] = None

    __properties = [
        "name", "cluster_by", "external_volume", "base_location", "comment"
    ]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IcebergTableLike:
        """Create an instance of IcebergTableLike from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> IcebergTableLike:
        """Create an instance of IcebergTableLike from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return IcebergTableLike.parse_obj(obj)

        _obj = IcebergTableLike.parse_obj({
            "name":
            obj.get("name"),
            "cluster_by":
            obj.get("cluster_by"),
            "external_volume":
            obj.get("external_volume"),
            "base_location":
            obj.get("base_location"),
            "comment":
            obj.get("comment"),
        })

        return _obj


from typing import Optional, List, Dict


class IcebergTableLikeModel():

    def __init__(
        self,
        name: str,
        # optional properties
        cluster_by: Optional[List[str]] = None,
        external_volume: Optional[str] = None,
        base_location: Optional[str] = None,
        comment: Optional[str] = None,
    ):
        """A model object representing the IcebergTableLike resource.

        Constructs an object of type IcebergTableLike with the provided properties.

        Parameters
        __________
        name : str
            Specifies the name for the table, must be unique for the schema in which the table is created
        cluster_by : List[str], optional
            Specifies one or more columns or column expressions in the table as the clustering key
        external_volume : str, optional
            Specifies the name of the external volume to use for the table
        base_location : str, optional
            Specifies the path to a directory where Snowflake can write data and metadata files for the table
        comment : str, optional
            Specifies a comment for the table
        """

        self.name = name
        self.cluster_by = cluster_by
        self.external_volume = external_volume
        self.base_location = base_location
        self.comment = comment

    __properties = [
        "name", "cluster_by", "external_volume", "base_location", "comment"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return IcebergTableLike(
            name=self.name,
            cluster_by=self.cluster_by,
            external_volume=self.external_volume,
            base_location=self.base_location,
            comment=self.comment,
        )

    @classmethod
    def _from_model(cls, model) -> IcebergTableLikeModel:
        return IcebergTableLikeModel(
            name=model.name,
            cluster_by=model.cluster_by,
            external_volume=model.external_volume,
            base_location=model.base_location,
            comment=model.comment,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a IcebergTableLike.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the IcebergTableLike object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> IcebergTableLikeModel:
        """Creates an instance of IcebergTableLike from a dict.

        This method constructs a IcebergTableLike object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        IcebergTableLike
            A IcebergTableLike object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(IcebergTableLike.from_dict(obj))


IcebergTableLike._model_class = IcebergTableLikeModel
