# coding: utf-8
"""
    Snowflake Notification Integration API.

    The Snowflake Notification Integration API is a REST API that you can use to access, update, and perform certain actions on Notification Integration resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.notification_integration._generated.models.notification_hook import NotificationHook

from pydantic import ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class NotificationEmail(NotificationHook):
    """A model object representing the NotificationEmail resource.

    Constructs an object of type NotificationEmail with the provided properties.

    Parameters
    __________
    allowed_recipients : List[str], optional
        A comma-separated list of quoted email addresses that can receive notification emails from this integration.
    default_recipients : List[str], optional
        A comma-separated list of default recipients for messages sent with this integration.
    default_subject : str, optional
        the default subject line for messages sent with this integration.
    """

    allowed_recipients: Optional[List[StrictStr]] = None

    default_recipients: Optional[List[StrictStr]] = None

    default_subject: Optional[StrictStr] = None

    __properties = ["type"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NotificationEmail:
        """Create an instance of NotificationEmail from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        _dict['type'] = NotificationHook.get_child_model_discriminator_value(
            'NotificationEmail')

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> NotificationEmail:
        """Create an instance of NotificationEmail from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return NotificationEmail.parse_obj(obj)

        _obj = NotificationEmail.parse_obj({
            "allowed_recipients":
            obj.get("allowed_recipients"),
            "default_recipients":
            obj.get("default_recipients"),
            "default_subject":
            obj.get("default_subject"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.notification_integration._generated.models.notification_hook import NotificationHook


class NotificationEmailModel(NotificationHook):

    def __init__(
        self,  # optional properties
        allowed_recipients: Optional[List[str]] = None,
        default_recipients: Optional[List[str]] = None,
        default_subject: Optional[str] = None,
    ):
        """A model object representing the NotificationEmail resource.

        Constructs an object of type NotificationEmail with the provided properties.

        Parameters
        __________
        allowed_recipients : List[str], optional
            A comma-separated list of quoted email addresses that can receive notification emails from this integration.
        default_recipients : List[str], optional
            A comma-separated list of default recipients for messages sent with this integration.
        default_subject : str, optional
            the default subject line for messages sent with this integration.
        """

        super().__init__()
        self.allowed_recipients = allowed_recipients
        self.default_recipients = default_recipients
        self.default_subject = default_subject

    __properties = ["type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return NotificationEmail(
            allowed_recipients=self.allowed_recipients,
            default_recipients=self.default_recipients,
            default_subject=self.default_subject,
        )

    @classmethod
    def _from_model(cls, model) -> NotificationEmailModel:
        return NotificationEmailModel(
            allowed_recipients=model.allowed_recipients,
            default_recipients=model.default_recipients,
            default_subject=model.default_subject,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a NotificationEmail.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the NotificationEmail object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> NotificationEmailModel:
        """Creates an instance of NotificationEmail from a dict.

        This method constructs a NotificationEmail object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        NotificationEmail
            A NotificationEmail object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(NotificationEmail.from_dict(obj))


NotificationEmail._model_class = NotificationEmailModel
