# coding: utf-8
"""
    Snowflake Notification Integration API.

    The Snowflake Notification Integration API is a REST API that you can use to access, update, and perform certain actions on Notification Integration resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.notification_integration._generated.models.notification_hook import NotificationHook

from snowflake.core.notification_integration._generated.models.webhook_secret import WebhookSecret

from pydantic import ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class NotificationWebhook(NotificationHook):
    """A model object representing the NotificationWebhook resource.

    Constructs an object of type NotificationWebhook with the provided properties.

    Parameters
    __________
    webhook_url : str
        The URL for the webhook. The URL must use the https:// protocol.
    webhook_secret : WebhookSecret, optional

    webhook_body_template : str, optional
        A template for the body of the HTTP request to send for the notification.
    webhook_headers : str, optional
        A list of HTTP headers and values to include in the HTTP request for the webhook.
    """

    webhook_url: StrictStr

    webhook_secret: Optional[WebhookSecret] = None

    webhook_body_template: Optional[StrictStr] = None

    webhook_headers: Optional[Dict[str, StrictStr]] = None

    __properties = ["type"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NotificationWebhook:
        """Create an instance of NotificationWebhook from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of webhook_secret
        if self.webhook_secret:
            _dict['webhook_secret'] = self.webhook_secret.to_dict()

        _dict['type'] = NotificationHook.get_child_model_discriminator_value(
            'NotificationWebhook')

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> NotificationWebhook:
        """Create an instance of NotificationWebhook from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return NotificationWebhook.parse_obj(obj)

        _obj = NotificationWebhook.parse_obj({
            "webhook_url":
            obj.get("webhook_url"),
            "webhook_secret":
            WebhookSecret.from_dict(obj.get("webhook_secret"))
            if obj.get("webhook_secret") is not None else None,
            "webhook_body_template":
            obj.get("webhook_body_template"),
            "webhook_headers":
            obj.get("webhook_headers"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.notification_integration._generated.models.notification_hook import NotificationHook

from snowflake.core.notification_integration._generated.models.webhook_secret import WebhookSecret


class NotificationWebhookModel(NotificationHook):

    def __init__(
        self,
        webhook_url: str,
        # optional properties
        webhook_secret: Optional[WebhookSecret] = None,
        webhook_body_template: Optional[str] = None,
        webhook_headers: Optional[str] = None,
    ):
        """A model object representing the NotificationWebhook resource.

        Constructs an object of type NotificationWebhook with the provided properties.

        Parameters
        __________
        webhook_url : str
            The URL for the webhook. The URL must use the https:// protocol.
        webhook_secret : WebhookSecret, optional

        webhook_body_template : str, optional
            A template for the body of the HTTP request to send for the notification.
        webhook_headers : str, optional
            A list of HTTP headers and values to include in the HTTP request for the webhook.
        """

        super().__init__()
        self.webhook_url = webhook_url
        self.webhook_secret = webhook_secret
        self.webhook_body_template = webhook_body_template
        self.webhook_headers = webhook_headers

    __properties = ["type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return NotificationWebhook(
            webhook_url=self.webhook_url,
            webhook_secret=self.webhook_secret._to_model()
            if self.webhook_secret is not None else None,
            webhook_body_template=self.webhook_body_template,
            webhook_headers=self.webhook_headers,
        )

    @classmethod
    def _from_model(cls, model) -> NotificationWebhookModel:
        return NotificationWebhookModel(
            webhook_url=model.webhook_url,
            webhook_secret=WebhookSecretModel._from_model(model.webhook_secret)
            if model.webhook_secret is not None else None,
            webhook_body_template=model.webhook_body_template,
            webhook_headers=model.webhook_headers,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a NotificationWebhook.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the NotificationWebhook object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> NotificationWebhookModel:
        """Creates an instance of NotificationWebhook from a dict.

        This method constructs a NotificationWebhook object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        NotificationWebhook
            A NotificationWebhook object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(NotificationWebhook.from_dict(obj))


NotificationWebhook._model_class = NotificationWebhookModel
